/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.Objects.TTEntityRegistry;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.StrollThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidType;

public class FennecFoxEntity
extends Animal
implements VariantHolder<Type> {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(FennecFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(FennecFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int FLAG_SITTING = 1;
    public static final int FLAG_CROUCHING = 4;
    public static final int FLAG_INTERESTED = 8;
    public static final int FLAG_POUNCING = 16;
    private static final int FLAG_SLEEPING = 32;
    private static final int FLAG_FACEPLANTED = 64;
    private static final int FLAG_DEFENDING = 128;
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_0 = SynchedEntityData.m_135353_(FennecFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_1 = SynchedEntityData.m_135353_(FennecFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    static final Predicate<ItemEntity> ALLOWED_ITEMS = p_289438_ -> !p_289438_.m_32063_() && p_289438_.m_6084_();
    private static final Predicate<Entity> TRUSTED_TARGET_SELECTOR = p_287481_ -> {
        if (!(p_287481_ instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)p_287481_;
        return livingentity.m_21214_() != null && livingentity.m_21215_() < livingentity.f_19797_ + 600;
    };
    static final Predicate<Entity> STALKABLE_PREY = p_28498_ -> p_28498_ instanceof Chicken || p_28498_ instanceof Rabbit;
    private static final Predicate<Entity> AVOID_PLAYERS = p_28463_ -> !p_28463_.m_20163_() && EntitySelector.f_20406_.test(p_28463_);
    private static final int MIN_TICKS_BEFORE_EAT = 600;
    private Goal landTargetGoal;
    private Goal turtleEggTargetGoal;
    private Goal fishTargetGoal;
    private float interestedAngle;
    private float interestedAngleO;
    float crouchAmount;
    float crouchAmountO;
    private int ticksSinceEaten;

    public FennecFoxEntity(EntityType<? extends FennecFoxEntity> p_28451_, Level p_28452_) {
        super(p_28451_, p_28452_);
        this.f_21365_ = new FoxLookControl();
        this.f_21342_ = new FoxMoveControl();
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 0.0f);
        this.m_21553_(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TRUSTED_ID_0, Optional.empty());
        this.f_19804_.m_135372_(DATA_TRUSTED_ID_1, Optional.empty());
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    protected void m_8099_() {
        this.landTargetGoal = new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, false, false, p_28604_ -> p_28604_ instanceof Chicken || p_28604_ instanceof Rabbit);
        this.turtleEggTargetGoal = new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, false, false, Turtle.f_30122_);
        this.fishTargetGoal = new NearestAttackableTargetGoal((Mob)this, AbstractFish.class, 20, false, false, p_28600_ -> p_28600_ instanceof AbstractSchoolingFish);
        this.f_21345_.m_25352_(3, (Goal)new CatRelaxOnOwnerGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FoxFloatGoal());
        this.f_21345_.m_25352_(0, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.m_9236_()));
        this.f_21345_.m_25352_(1, (Goal)new FaceplantGoal());
        this.f_21345_.m_25352_(2, (Goal)new FoxPanicGoal(2.2));
        this.f_21345_.m_25352_(3, (Goal)new FoxBreedGoal(1.0));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 1.6, 1.4, p_289437_ -> AVOID_PLAYERS.test((Entity)p_289437_) && !this.trusts(p_289437_.m_20148_()) && !this.isDefending()));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 8.0f, 1.6, 1.4, p_289439_ -> !((Wolf)p_289439_).m_21824_() && !this.isDefending()));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 8.0f, 1.6, 1.4, p_28585_ -> !this.isDefending()));
        this.f_21345_.m_25352_(5, (Goal)new StalkPreyGoal());
        this.f_21345_.m_25352_(6, (Goal)new FoxPounceGoal());
        this.f_21345_.m_25352_(6, (Goal)new SeekShelterGoal(1.25));
        this.f_21345_.m_25352_(7, (Goal)new FoxMeleeAttackGoal(1.2f, true));
        this.f_21345_.m_25352_(7, (Goal)new SleepGoal());
        this.f_21345_.m_25352_(8, (Goal)new FoxFollowParentGoal(this, 1.25));
        this.f_21345_.m_25352_(9, (Goal)new FoxStrollThroughVillageGoal(32, 200));
        this.f_21345_.m_25352_(10, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(11, (Goal)new FoxSearchForItemsGoal());
        this.f_21345_.m_25352_(12, (Goal)new FoxLookAtPlayerGoal((Mob)this, Player.class, 24.0f));
        this.f_21345_.m_25352_(13, (Goal)new PerchAndSearchGoal());
        this.f_21346_.m_25352_(3, (Goal)new DefendTrustedTargetGoal(LivingEntity.class, false, false, p_289440_ -> TRUSTED_TARGET_SELECTOR.test((Entity)p_289440_) && !this.trusts(p_289440_.m_20148_())));
    }

    public SoundEvent m_7866_(ItemStack p_28540_) {
        return SoundEvents.f_11947_;
    }

    public void m_8107_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21515_()) {
            LivingEntity livingentity;
            ++this.ticksSinceEaten;
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.canEat(itemstack)) {
                if (this.ticksSinceEaten > 600) {
                    ItemStack itemstack1 = itemstack.m_41671_(this.m_9236_(), (LivingEntity)this);
                    if (!itemstack1.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, itemstack1);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.f_19796_.m_188501_() < 0.1f) {
                    this.m_5496_(this.m_7866_(itemstack), 1.0f, 1.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)45);
                }
            }
            if ((livingentity = this.m_5448_()) == null || !livingentity.m_6084_()) {
                this.setIsCrouching(false);
                this.setIsInterested(false);
            }
        }
        if (this.m_5803_() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
        super.m_8107_();
        if (this.isDefending() && this.f_19796_.m_188501_() < 0.05f) {
            this.m_5496_(SoundEvents.f_11943_, 1.0f, 1.0f);
        }
    }

    protected boolean m_6107_() {
        return this.m_21224_();
    }

    private boolean canEat(ItemStack p_28598_) {
        return p_28598_.m_41720_().m_41472_() && this.m_5448_() == null && this.m_20096_() && !this.m_5803_();
    }

    protected void m_213945_(RandomSource p_218171_, DifficultyInstance p_218172_) {
        if (p_218171_.m_188501_() < 0.2f) {
            float f = p_218171_.m_188501_();
            ItemStack itemstack = f < 0.05f ? new ItemStack((ItemLike)Items.f_42415_) : (f < 0.2f ? new ItemStack((ItemLike)Items.f_42521_) : (f < 0.4f ? (p_218171_.m_188499_() ? new ItemStack((ItemLike)Items.f_42648_) : new ItemStack((ItemLike)Items.f_42649_)) : (f < 0.6f ? new ItemStack((ItemLike)Items.f_41866_) : (f < 0.8f ? new ItemStack((ItemLike)Items.f_41830_) : new ItemStack((ItemLike)Items.f_41982_)))));
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    public void m_7822_(byte p_28456_) {
        if (p_28456_ == 45) {
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemstack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
                }
            }
        } else {
            super.m_7822_(p_28456_);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    @Nullable
    public FennecFoxEntity getBreedOffspring(ServerLevel p_148912_, AgeableMob p_148913_) {
        FennecFoxEntity fox = (FennecFoxEntity)((EntityType)TTEntityRegistry.FENNEC_FOX.get()).m_20615_((Level)p_148912_);
        if (fox != null) {
            fox.setVariant(this.f_19796_.m_188499_() ? this.getVariant() : ((FennecFoxEntity)p_148913_).getVariant());
        }
        return fox;
    }

    public static boolean checkFoxSpawnRules(EntityType<FennecFoxEntity> p_218176_, LevelAccessor p_218177_, MobSpawnType p_218178_, BlockPos p_218179_, RandomSource p_218180_) {
        return p_218177_.m_8055_(p_218179_.m_7495_()).m_60713_(Blocks.f_49992_) && FennecFoxEntity.m_186209_((BlockAndTintGetter)p_218177_, (BlockPos)p_218179_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_28487_, DifficultyInstance p_28488_, MobSpawnType p_28489_, @Nullable SpawnGroupData p_28490_, @Nullable CompoundTag p_28491_) {
        Holder holder = p_28487_.m_204166_(this.m_20183_());
        Type fox$type = Type.byBiome((Holder<Biome>)holder);
        boolean flag = false;
        if (p_28490_ instanceof FoxGroupData) {
            FoxGroupData fox$foxgroupdata = (FoxGroupData)((Object)p_28490_);
            fox$type = fox$foxgroupdata.type;
            if (fox$foxgroupdata.m_146777_() >= 2) {
                flag = true;
            }
        } else {
            p_28490_ = new FoxGroupData(fox$type);
        }
        this.setVariant(fox$type);
        if (flag) {
            this.m_146762_(-24000);
        }
        if (p_28487_ instanceof ServerLevel) {
            this.setTargetGoals();
        }
        this.m_213945_(p_28487_.m_213780_(), p_28488_);
        return super.m_6518_(p_28487_, p_28488_, p_28489_, p_28490_, p_28491_);
    }

    private void setTargetGoals() {
        if (this.getVariant() == Type.RED) {
            this.f_21346_.m_25352_(4, this.landTargetGoal);
            this.f_21346_.m_25352_(4, this.turtleEggTargetGoal);
            this.f_21346_.m_25352_(6, this.fishTargetGoal);
        } else {
            this.f_21346_.m_25352_(4, this.fishTargetGoal);
            this.f_21346_.m_25352_(6, this.landTargetGoal);
            this.f_21346_.m_25352_(6, this.turtleEggTargetGoal);
        }
    }

    protected void m_142075_(Player p_148908_, InteractionHand p_148909_, ItemStack p_148910_) {
        if (this.m_6898_(p_148910_)) {
            this.m_5496_(this.m_7866_(p_148910_), 1.0f, 1.0f);
        }
        super.m_142075_(p_148908_, p_148909_, p_148910_);
    }

    protected float m_6431_(Pose p_28500_, EntityDimensions p_28501_) {
        return this.m_6162_() ? p_28501_.f_20378_ * 0.85f : 0.4f;
    }

    public Type getVariant() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_TYPE_ID));
    }

    public void setVariant(Type p_28465_) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)p_28465_.getId());
    }

    List<UUID> getTrustedUUIDs() {
        ArrayList list = Lists.newArrayList();
        list.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).orElse(null));
        list.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_1)).orElse(null));
        return list;
    }

    void addTrustedUUID(@Nullable UUID p_28516_) {
        if (((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).isPresent()) {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_1, Optional.ofNullable(p_28516_));
        } else {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_0, Optional.ofNullable(p_28516_));
        }
    }

    public void m_7380_(CompoundTag p_28518_) {
        super.m_7380_(p_28518_);
        List<UUID> list = this.getTrustedUUIDs();
        ListTag listtag = new ListTag();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            listtag.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        p_28518_.m_128365_("Trusted", (Tag)listtag);
        p_28518_.m_128379_("Sleeping", this.m_5803_());
        p_28518_.m_128359_("Type", this.getVariant().m_7912_());
        p_28518_.m_128379_("Sitting", this.isSitting());
        p_28518_.m_128379_("Crouching", this.m_6047_());
    }

    public void m_7378_(CompoundTag p_28493_) {
        super.m_7378_(p_28493_);
        ListTag listtag = p_28493_.m_128437_("Trusted", 11);
        for (int i = 0; i < listtag.size(); ++i) {
            this.addTrustedUUID(NbtUtils.m_129233_((Tag)listtag.get(i)));
        }
        this.setSleeping(p_28493_.m_128471_("Sleeping"));
        this.setVariant(Type.byName(p_28493_.m_128461_("Type")));
        this.setSitting(p_28493_.m_128471_("Sitting"));
        this.setIsCrouching(p_28493_.m_128471_("Crouching"));
        if (this.m_9236_() instanceof ServerLevel) {
            this.setTargetGoals();
        }
    }

    public boolean isSitting() {
        return this.getFlag(1);
    }

    public void setSitting(boolean p_28611_) {
        this.setFlag(1, p_28611_);
    }

    public boolean isFaceplanted() {
        return this.getFlag(64);
    }

    void setFaceplanted(boolean p_28619_) {
        this.setFlag(64, p_28619_);
    }

    boolean isDefending() {
        return this.getFlag(128);
    }

    void setDefending(boolean p_28623_) {
        this.setFlag(128, p_28623_);
    }

    public boolean m_5803_() {
        return this.getFlag(32);
    }

    void setSleeping(boolean p_28627_) {
        this.setFlag(32, p_28627_);
    }

    private void setFlag(int p_28533_, boolean p_28534_) {
        if (p_28534_) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | p_28533_)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~p_28533_)));
        }
    }

    private boolean getFlag(int p_28609_) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & p_28609_) != 0;
    }

    public boolean m_7066_(ItemStack p_28552_) {
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)p_28552_);
        if (!this.m_6844_(equipmentslot).m_41619_()) {
            return false;
        }
        return equipmentslot == EquipmentSlot.MAINHAND && super.m_7066_(p_28552_);
    }

    public boolean m_7252_(ItemStack p_28578_) {
        Item item = p_28578_.m_41720_();
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_() || this.ticksSinceEaten > 0 && item.m_41472_() && !itemstack.m_41720_().m_41472_();
    }

    private void spitOutItem(ItemStack p_28602_) {
        if (!p_28602_.m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, p_28602_);
            itementity.m_32010_(40);
            itementity.m_32052_(this.m_20148_());
            this.m_5496_(SoundEvents.f_11952_, 1.0f, 1.0f);
            this.m_9236_().m_7967_((Entity)itementity);
        }
    }

    private void dropItemStack(ItemStack p_28606_) {
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), p_28606_);
        this.m_9236_().m_7967_((Entity)itementity);
    }

    protected void m_7581_(ItemEntity p_28514_) {
        ItemStack itemstack = p_28514_.m_32055_();
        if (this.m_7252_(itemstack)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.dropItemStack(itemstack.m_41620_(i - 1));
            }
            this.spitOutItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(p_28514_);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.m_21508_(EquipmentSlot.MAINHAND);
            this.m_7938_((Entity)p_28514_, itemstack.m_41613_());
            p_28514_.m_146870_();
            this.ticksSinceEaten = 0;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21515_()) {
            boolean flag = this.m_20069_();
            if (flag || this.m_5448_() != null || this.m_9236_().m_46470_()) {
                this.wakeUp();
            }
            if (flag || this.m_5803_()) {
                this.setSitting(false);
            }
            if (this.isFaceplanted() && this.m_9236_().f_46441_.m_188501_() < 0.2f) {
                BlockPos blockpos = this.m_20183_();
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                this.m_9236_().m_46796_(2001, blockpos, Block.m_49956_((BlockState)blockstate));
            }
        }
        this.interestedAngleO = this.interestedAngle;
        this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
        this.crouchAmountO = this.crouchAmount;
        if (this.m_6047_()) {
            this.crouchAmount += 0.2f;
            if (this.crouchAmount > 3.0f) {
                this.crouchAmount = 3.0f;
            }
        } else {
            this.crouchAmount = 0.0f;
        }
    }

    public boolean m_6898_(ItemStack p_28594_) {
        return p_28594_.m_204117_(ItemTags.f_144311_);
    }

    protected void m_5502_(Player p_28481_, Mob p_28482_) {
        ((FennecFoxEntity)p_28482_).addTrustedUUID(p_28481_.m_20148_());
    }

    public boolean isPouncing() {
        return this.getFlag(16);
    }

    public void setIsPouncing(boolean p_28613_) {
        this.setFlag(16, p_28613_);
    }

    public boolean isJumping() {
        return this.f_20899_;
    }

    public boolean isFullyCrouched() {
        return this.crouchAmount == 3.0f;
    }

    public void setIsCrouching(boolean p_28615_) {
        this.setFlag(4, p_28615_);
    }

    public boolean m_6047_() {
        return this.getFlag(4);
    }

    public void setIsInterested(boolean p_28617_) {
        this.setFlag(8, p_28617_);
    }

    public boolean isInterested() {
        return this.getFlag(8);
    }

    public float getHeadRollAngle(float p_28621_) {
        return Mth.m_14179_((float)p_28621_, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.11f * (float)Math.PI;
    }

    public float getCrouchAmount(float p_28625_) {
        return Mth.m_14179_((float)p_28625_, (float)this.crouchAmountO, (float)this.crouchAmount);
    }

    public void m_6710_(@Nullable LivingEntity p_28574_) {
        if (this.isDefending() && p_28574_ == null) {
            this.setDefending(false);
        }
        super.m_6710_(p_28574_);
    }

    protected int m_5639_(float p_28545_, float p_28546_) {
        return Mth.m_14167_((float)((p_28545_ - 5.0f) * p_28546_));
    }

    void wakeUp() {
        this.setSleeping(false);
    }

    void clearStates() {
        this.setIsInterested(false);
        this.setIsCrouching(false);
        this.setSitting(false);
        this.setSleeping(false);
        this.setDefending(false);
        this.setFaceplanted(false);
    }

    boolean canMove() {
        return !this.m_5803_() && !this.isSitting() && !this.isFaceplanted();
    }

    public void m_8032_() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent == SoundEvents.f_11949_) {
            this.m_5496_(soundevent, 2.0f, this.m_6100_());
        } else {
            super.m_8032_();
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        List list;
        if (this.m_5803_()) {
            return SoundEvents.f_11950_;
        }
        if (!this.m_9236_().m_46461_() && this.f_19796_.m_188501_() < 0.1f && (list = this.m_9236_().m_6443_(Player.class, this.m_20191_().m_82377_(16.0, 16.0, 16.0), EntitySelector.f_20408_)).isEmpty()) {
            return SoundEvents.f_11949_;
        }
        return SoundEvents.f_11944_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_28548_) {
        return SoundEvents.f_11948_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11946_;
    }

    boolean trusts(UUID p_28530_) {
        return this.getTrustedUUIDs().contains(p_28530_);
    }

    protected void m_6668_(DamageSource p_28536_) {
        super.m_6668_(p_28536_);
    }

    protected void m_5907_() {
        super.m_5907_();
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!itemstack.m_41619_()) {
            this.m_19983_(itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
    }

    public static boolean isPathClear(FennecFoxEntity p_28472_, LivingEntity p_28473_) {
        double d0 = p_28473_.m_20189_() - p_28472_.m_20189_();
        double d1 = p_28473_.m_20185_() - p_28472_.m_20185_();
        double d2 = d0 / d1;
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)j / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)j / 6.0f) : d3 / d2;
            for (int k = 1; k < 4; ++k) {
                if (p_28472_.m_9236_().m_8055_(BlockPos.m_274561_((double)(p_28472_.m_20185_() + d4), (double)(p_28472_.m_20186_() + (double)k), (double)(p_28472_.m_20189_() + d3))).m_247087_()) continue;
                return false;
            }
        }
        return true;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.55f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public class FoxLookControl
    extends LookControl {
        public FoxLookControl() {
            super((Mob)FennecFoxEntity.this);
        }

        public void m_8128_() {
            if (!FennecFoxEntity.this.m_5803_()) {
                super.m_8128_();
            }
        }

        protected boolean m_8106_() {
            return !FennecFoxEntity.this.isPouncing() && !FennecFoxEntity.this.m_6047_() && !FennecFoxEntity.this.isInterested() && !FennecFoxEntity.this.isFaceplanted();
        }
    }

    class FoxMoveControl
    extends MoveControl {
        public FoxMoveControl() {
            super((Mob)FennecFoxEntity.this);
        }

        public void m_8126_() {
            if (FennecFoxEntity.this.canMove()) {
                super.m_8126_();
            }
        }
    }

    static class CatRelaxOnOwnerGoal
    extends Goal {
        private final FennecFoxEntity cat;
        @Nullable
        private Villager ownerPlayer;
        @Nullable
        private BlockPos goalPos;
        private int onBedTicks;

        public CatRelaxOnOwnerGoal(FennecFoxEntity p_28203_) {
            this.cat = p_28203_;
        }

        public boolean m_8036_() {
            FennecFoxEntity livingentity = this.cat;
            if (livingentity instanceof Player) {
                this.ownerPlayer = (Villager)livingentity;
                if (!livingentity.m_5803_()) {
                    return false;
                }
                if (this.cat.m_20280_((Entity)this.ownerPlayer) > 100.0) {
                    return false;
                }
                BlockPos blockpos = this.ownerPlayer.m_20183_();
                BlockState blockstate = this.cat.m_9236_().m_8055_(blockpos);
                if (blockstate.m_204336_(BlockTags.f_13038_)) {
                    this.goalPos = blockstate.m_61145_((Property)BedBlock.f_54117_).map(p_28209_ -> blockpos.m_121945_(p_28209_.m_122424_())).orElseGet(() -> new BlockPos((Vec3i)blockpos));
                    return !this.spaceIsOccupied();
                }
            }
            return false;
        }

        private boolean spaceIsOccupied() {
            for (FennecFoxEntity cat : this.cat.m_9236_().m_45976_(FennecFoxEntity.class, new AABB(this.goalPos).m_82400_(2.0))) {
                if (cat == this.cat) continue;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.ownerPlayer != null && this.ownerPlayer.m_5803_() && this.goalPos != null && !this.spaceIsOccupied();
        }

        public void m_8056_() {
            if (this.goalPos != null) {
                this.cat.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
            }
        }

        public void m_8041_() {
            float f = this.cat.m_9236_().m_46942_(1.0f);
            if (!this.ownerPlayer.m_5803_() && (double)f > 0.77 && (double)f < 0.8 && (double)this.cat.m_9236_().m_213780_().m_188501_() < 0.7) {
                this.giveMorningGift();
            }
            this.onBedTicks = 0;
            this.cat.m_21573_().m_26573_();
        }

        private void giveMorningGift() {
            RandomSource randomsource = this.cat.m_217043_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            blockpos$mutableblockpos.m_122190_((Vec3i)(this.cat.m_21523_() ? this.cat.m_21524_().m_20183_() : this.cat.m_20183_()));
            this.cat.m_20984_(blockpos$mutableblockpos.m_123341_() + randomsource.m_188503_(11) - 5, blockpos$mutableblockpos.m_123342_() + randomsource.m_188503_(5) - 2, blockpos$mutableblockpos.m_123343_() + randomsource.m_188503_(11) - 5, false);
            blockpos$mutableblockpos.m_122190_((Vec3i)this.cat.m_20183_());
            LootTable loottable = this.cat.m_9236_().m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78724_);
            LootParams lootparams = new LootParams.Builder((ServerLevel)this.cat.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.cat.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this.cat).m_287235_(LootContextParamSets.f_81416_);
            for (ItemStack itemstack : loottable.m_287195_(lootparams)) {
                this.cat.m_9236_().m_7967_((Entity)new ItemEntity(this.cat.m_9236_(), (double)blockpos$mutableblockpos.m_123341_() - (double)Mth.m_14031_((float)(this.cat.f_20883_ * ((float)Math.PI / 180))), (double)blockpos$mutableblockpos.m_123342_(), (double)blockpos$mutableblockpos.m_123343_() + (double)Mth.m_14089_((float)(this.cat.f_20883_ * ((float)Math.PI / 180))), itemstack));
            }
        }

        public void m_8037_() {
            if (this.ownerPlayer != null && this.goalPos != null) {
                this.cat.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
                if (this.cat.m_20280_((Entity)this.ownerPlayer) < 2.5) {
                    ++this.onBedTicks;
                    if (this.onBedTicks <= this.m_183277_(16)) {
                        this.cat.m_21391_((Entity)this.ownerPlayer, 45.0f, 45.0f);
                    }
                }
            }
        }
    }

    class FoxFloatGoal
    extends FloatGoal {
        public FoxFloatGoal() {
            super((Mob)FennecFoxEntity.this);
        }

        public void m_8056_() {
            super.m_8056_();
            FennecFoxEntity.this.clearStates();
        }

        public boolean m_8036_() {
            return FennecFoxEntity.this.m_20069_() && FennecFoxEntity.this.m_204036_(FluidTags.f_13131_) > 0.25 || FennecFoxEntity.this.m_20077_() || FennecFoxEntity.this.isInFluidType((fluidType, height) -> FennecFoxEntity.this.canSwimInFluidType((FluidType)fluidType) && height > 0.25);
        }
    }

    class FaceplantGoal
    extends Goal {
        int countdown;

        public FaceplantGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FennecFoxEntity.this.isFaceplanted();
        }

        public boolean m_8045_() {
            return this.m_8036_() && this.countdown > 0;
        }

        public void m_8056_() {
            this.countdown = this.m_183277_(40);
        }

        public void m_8041_() {
            FennecFoxEntity.this.setFaceplanted(false);
        }

        public void m_8037_() {
            --this.countdown;
        }
    }

    class FoxPanicGoal
    extends PanicGoal {
        public FoxPanicGoal(double p_28734_) {
            super((PathfinderMob)FennecFoxEntity.this, p_28734_);
        }

        public boolean m_202729_() {
            return !FennecFoxEntity.this.isDefending() && super.m_202729_();
        }
    }

    class FoxBreedGoal
    extends BreedGoal {
        public FoxBreedGoal(double p_28668_) {
            super((Animal)FennecFoxEntity.this, p_28668_);
        }

        public void m_8056_() {
            ((FennecFoxEntity)this.f_25113_).clearStates();
            ((FennecFoxEntity)this.f_25115_).clearStates();
            super.m_8056_();
        }

        protected void m_8026_() {
            ServerLevel serverlevel = (ServerLevel)this.f_25114_;
            FennecFoxEntity fox = (FennecFoxEntity)this.f_25113_.m_142606_(serverlevel, (AgeableMob)this.f_25115_);
            BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)this.f_25113_, (Mob)this.f_25115_, (AgeableMob)fox);
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
            fox = (FennecFoxEntity)event.getChild();
            if (cancelled) {
                this.f_25113_.m_146762_(6000);
                this.f_25115_.m_146762_(6000);
                this.f_25113_.m_27594_();
                this.f_25115_.m_27594_();
                return;
            }
            if (fox != null) {
                ServerPlayer serverplayer = this.f_25113_.m_27592_();
                ServerPlayer serverplayer1 = this.f_25115_.m_27592_();
                ServerPlayer serverplayer2 = serverplayer;
                if (serverplayer != null) {
                    fox.addTrustedUUID(serverplayer.m_20148_());
                } else {
                    serverplayer2 = serverplayer1;
                }
                if (serverplayer1 != null && serverplayer != serverplayer1) {
                    fox.addTrustedUUID(serverplayer1.m_20148_());
                }
                if (serverplayer2 != null) {
                    serverplayer2.m_36220_(Stats.f_12937_);
                    CriteriaTriggers.f_10581_.m_147278_(serverplayer2, this.f_25113_, this.f_25115_, (AgeableMob)fox);
                }
                this.f_25113_.m_146762_(6000);
                this.f_25115_.m_146762_(6000);
                this.f_25113_.m_27594_();
                this.f_25115_.m_27594_();
                fox.m_146762_(-24000);
                fox.m_7678_(this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), 0.0f, 0.0f);
                serverlevel.m_47205_((Entity)fox);
                this.f_25114_.m_7605_((Entity)this.f_25113_, (byte)18);
                if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                    this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), this.f_25113_.m_217043_().m_188503_(7) + 1));
                }
            }
        }
    }

    class StalkPreyGoal
    extends Goal {
        public StalkPreyGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (FennecFoxEntity.this.m_5803_()) {
                return false;
            }
            LivingEntity livingentity = FennecFoxEntity.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && STALKABLE_PREY.test((Entity)livingentity) && FennecFoxEntity.this.m_20280_((Entity)livingentity) > 36.0 && !FennecFoxEntity.this.m_6047_() && !FennecFoxEntity.this.isInterested() && !FennecFoxEntity.this.f_20899_;
        }

        public void m_8056_() {
            FennecFoxEntity.this.setSitting(false);
            FennecFoxEntity.this.setFaceplanted(false);
        }

        public void m_8041_() {
            LivingEntity livingentity = FennecFoxEntity.this.m_5448_();
            if (livingentity != null && FennecFoxEntity.isPathClear(FennecFoxEntity.this, livingentity)) {
                FennecFoxEntity.this.setIsInterested(true);
                FennecFoxEntity.this.setIsCrouching(true);
                FennecFoxEntity.this.m_21573_().m_26573_();
                FennecFoxEntity.this.m_21563_().m_24960_((Entity)livingentity, (float)FennecFoxEntity.this.m_8085_(), (float)FennecFoxEntity.this.m_8132_());
            } else {
                FennecFoxEntity.this.setIsInterested(false);
                FennecFoxEntity.this.setIsCrouching(false);
            }
        }

        public void m_8037_() {
            LivingEntity livingentity = FennecFoxEntity.this.m_5448_();
            if (livingentity != null) {
                FennecFoxEntity.this.m_21563_().m_24960_((Entity)livingentity, (float)FennecFoxEntity.this.m_8085_(), (float)FennecFoxEntity.this.m_8132_());
                if (FennecFoxEntity.this.m_20280_((Entity)livingentity) <= 36.0) {
                    FennecFoxEntity.this.setIsInterested(true);
                    FennecFoxEntity.this.setIsCrouching(true);
                    FennecFoxEntity.this.m_21573_().m_26573_();
                } else {
                    FennecFoxEntity.this.m_21573_().m_5624_((Entity)livingentity, 1.5);
                }
            }
        }
    }

    public class FoxPounceGoal
    extends JumpGoal {
        public boolean m_8036_() {
            if (!FennecFoxEntity.this.isFullyCrouched()) {
                return false;
            }
            LivingEntity livingentity = FennecFoxEntity.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                if (livingentity.m_6374_() != livingentity.m_6350_()) {
                    return false;
                }
                boolean flag = FennecFoxEntity.isPathClear(FennecFoxEntity.this, livingentity);
                if (!flag) {
                    FennecFoxEntity.this.m_21573_().m_6570_((Entity)livingentity, 0);
                    FennecFoxEntity.this.setIsCrouching(false);
                    FennecFoxEntity.this.setIsInterested(false);
                }
                return flag;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = FennecFoxEntity.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                double d0 = FennecFoxEntity.this.m_20184_().f_82480_;
                return !(d0 * d0 < (double)0.05f && Math.abs(FennecFoxEntity.this.m_146909_()) < 15.0f && FennecFoxEntity.this.m_20096_() || FennecFoxEntity.this.isFaceplanted());
            }
            return false;
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8056_() {
            FennecFoxEntity.this.m_6862_(true);
            FennecFoxEntity.this.setIsPouncing(true);
            FennecFoxEntity.this.setIsInterested(false);
            LivingEntity livingentity = FennecFoxEntity.this.m_5448_();
            if (livingentity != null) {
                FennecFoxEntity.this.m_21563_().m_24960_((Entity)livingentity, 60.0f, 30.0f);
                Vec3 vec3 = new Vec3(livingentity.m_20185_() - FennecFoxEntity.this.m_20185_(), livingentity.m_20186_() - FennecFoxEntity.this.m_20186_(), livingentity.m_20189_() - FennecFoxEntity.this.m_20189_()).m_82541_();
                FennecFoxEntity.this.m_20256_(FennecFoxEntity.this.m_20184_().m_82520_(vec3.f_82479_ * 0.8, 0.9, vec3.f_82481_ * 0.8));
            }
            FennecFoxEntity.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            FennecFoxEntity.this.setIsCrouching(false);
            FennecFoxEntity.this.crouchAmount = 0.0f;
            FennecFoxEntity.this.crouchAmountO = 0.0f;
            FennecFoxEntity.this.setIsInterested(false);
            FennecFoxEntity.this.setIsPouncing(false);
        }

        public void m_8037_() {
            LivingEntity livingentity = FennecFoxEntity.this.m_5448_();
            if (livingentity != null) {
                FennecFoxEntity.this.m_21563_().m_24960_((Entity)livingentity, 60.0f, 30.0f);
            }
            if (!FennecFoxEntity.this.isFaceplanted()) {
                Vec3 vec3 = FennecFoxEntity.this.m_20184_();
                if (vec3.f_82480_ * vec3.f_82480_ < (double)0.03f && FennecFoxEntity.this.m_146909_() != 0.0f) {
                    FennecFoxEntity.this.m_146926_(Mth.m_14189_((float)0.2f, (float)FennecFoxEntity.this.m_146909_(), (float)0.0f));
                } else {
                    double d0 = vec3.m_165924_();
                    double d1 = Math.signum(-vec3.f_82480_) * Math.acos(d0 / vec3.m_82553_()) * 57.2957763671875;
                    FennecFoxEntity.this.m_146926_((float)d1);
                }
            }
            if (livingentity != null && FennecFoxEntity.this.m_20270_((Entity)livingentity) <= 2.0f) {
                FennecFoxEntity.this.m_7327_((Entity)livingentity);
            } else if (FennecFoxEntity.this.m_146909_() > 0.0f && FennecFoxEntity.this.m_20096_() && (float)FennecFoxEntity.this.m_20184_().f_82480_ != 0.0f && FennecFoxEntity.this.m_9236_().m_8055_(FennecFoxEntity.this.m_20183_()).m_60713_(Blocks.f_50125_)) {
                FennecFoxEntity.this.m_146926_(60.0f);
                FennecFoxEntity.this.m_6710_(null);
                FennecFoxEntity.this.setFaceplanted(true);
            }
        }
    }

    class SeekShelterGoal
    extends FleeSunGoal {
        private int interval;

        public SeekShelterGoal(double p_28777_) {
            super((PathfinderMob)FennecFoxEntity.this, p_28777_);
            this.interval = SeekShelterGoal.m_186073_((int)100);
        }

        public boolean m_8036_() {
            if (!FennecFoxEntity.this.m_5803_() && this.f_25214_.m_5448_() == null) {
                if (FennecFoxEntity.this.m_9236_().m_46470_() && FennecFoxEntity.this.m_9236_().m_45527_(this.f_25214_.m_20183_())) {
                    return this.m_25226_();
                }
                if (this.interval > 0) {
                    --this.interval;
                    return false;
                }
                this.interval = 100;
                BlockPos blockpos = this.f_25214_.m_20183_();
                return FennecFoxEntity.this.m_9236_().m_46461_() && FennecFoxEntity.this.m_9236_().m_45527_(blockpos) && !((ServerLevel)FennecFoxEntity.this.m_9236_()).m_8802_(blockpos) && this.m_25226_();
            }
            return false;
        }

        public void m_8056_() {
            FennecFoxEntity.this.clearStates();
            super.m_8056_();
        }
    }

    class FoxMeleeAttackGoal
    extends MeleeAttackGoal {
        public FoxMeleeAttackGoal(double p_28720_, boolean p_28721_) {
            super((PathfinderMob)FennecFoxEntity.this, p_28720_, p_28721_);
        }

        protected void m_6739_(LivingEntity p_28724_, double p_28725_) {
            double d0 = this.m_6639_(p_28724_);
            if (p_28725_ <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)p_28724_);
                FennecFoxEntity.this.m_5496_(SoundEvents.f_11945_, 1.0f, 1.0f);
            }
        }

        public void m_8056_() {
            FennecFoxEntity.this.setIsInterested(false);
            super.m_8056_();
        }

        public boolean m_8036_() {
            return !FennecFoxEntity.this.isSitting() && !FennecFoxEntity.this.m_5803_() && !FennecFoxEntity.this.m_6047_() && !FennecFoxEntity.this.isFaceplanted() && super.m_8036_();
        }
    }

    class SleepGoal
    extends FoxBehaviorGoal {
        private static final int WAIT_TIME_BEFORE_SLEEP = SleepGoal.m_186073_((int)140);
        private int countdown;

        public SleepGoal() {
            this.countdown = FennecFoxEntity.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (FennecFoxEntity.this.f_20900_ == 0.0f && FennecFoxEntity.this.f_20901_ == 0.0f && FennecFoxEntity.this.f_20902_ == 0.0f) {
                return this.canSleep() || FennecFoxEntity.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return FennecFoxEntity.this.m_9236_().m_46462_() && this.hasShelter() && !this.alertable() && !FennecFoxEntity.this.f_146808_;
        }

        public void m_8041_() {
            this.countdown = FennecFoxEntity.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            FennecFoxEntity.this.clearStates();
        }

        public void m_8056_() {
            FennecFoxEntity.this.setSitting(false);
            FennecFoxEntity.this.setIsCrouching(false);
            FennecFoxEntity.this.setIsInterested(false);
            FennecFoxEntity.this.m_6862_(false);
            FennecFoxEntity.this.setSleeping(true);
            FennecFoxEntity.this.m_21573_().m_26573_();
            FennecFoxEntity.this.m_21566_().m_6849_(FennecFoxEntity.this.m_20185_(), FennecFoxEntity.this.m_20186_(), FennecFoxEntity.this.m_20189_(), 0.0);
        }
    }

    class FoxFollowParentGoal
    extends FollowParentGoal {
        private final FennecFoxEntity fox;

        public FoxFollowParentGoal(FennecFoxEntity p_28696_, double p_28697_) {
            super((Animal)p_28696_, p_28697_);
            this.fox = p_28696_;
        }

        public boolean m_8036_() {
            return !this.fox.isDefending() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.fox.isDefending() && super.m_8045_();
        }

        public void m_8056_() {
            this.fox.clearStates();
            super.m_8056_();
        }
    }

    class FoxStrollThroughVillageGoal
    extends StrollThroughVillageGoal {
        public FoxStrollThroughVillageGoal(int p_28754_, int p_28755_) {
            super((PathfinderMob)FennecFoxEntity.this, p_28755_);
        }

        public void m_8056_() {
            FennecFoxEntity.this.clearStates();
            super.m_8056_();
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.canFoxMove();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.canFoxMove();
        }

        private boolean canFoxMove() {
            return !FennecFoxEntity.this.m_5803_() && !FennecFoxEntity.this.isSitting() && !FennecFoxEntity.this.isDefending() && FennecFoxEntity.this.m_5448_() == null;
        }
    }

    class FoxSearchForItemsGoal
    extends Goal {
        public FoxSearchForItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!FennecFoxEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return false;
            }
            if (FennecFoxEntity.this.m_5448_() == null && FennecFoxEntity.this.m_21188_() == null) {
                if (!FennecFoxEntity.this.canMove()) {
                    return false;
                }
                if (FennecFoxEntity.this.m_217043_().m_188503_(FoxSearchForItemsGoal.m_186073_((int)10)) != 0) {
                    return false;
                }
                List list = FennecFoxEntity.this.m_9236_().m_6443_(ItemEntity.class, FennecFoxEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
                return !list.isEmpty() && FennecFoxEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
            }
            return false;
        }

        public void m_8037_() {
            List list = FennecFoxEntity.this.m_9236_().m_6443_(ItemEntity.class, FennecFoxEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack itemstack = FennecFoxEntity.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_() && !list.isEmpty()) {
                FennecFoxEntity.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }

        public void m_8056_() {
            List list = FennecFoxEntity.this.m_9236_().m_6443_(ItemEntity.class, FennecFoxEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                FennecFoxEntity.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    class FoxLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public FoxLookAtPlayerGoal(Mob p_28707_, Class<? extends LivingEntity> p_28708_, float p_28709_) {
            super(p_28707_, p_28708_, p_28709_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !FennecFoxEntity.this.isFaceplanted() && !FennecFoxEntity.this.isInterested();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !FennecFoxEntity.this.isFaceplanted() && !FennecFoxEntity.this.isInterested();
        }
    }

    class PerchAndSearchGoal
    extends FoxBehaviorGoal {
        private double relX;
        private double relZ;
        private int lookTime;
        private int looksRemaining;

        public PerchAndSearchGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return FennecFoxEntity.this.m_21188_() == null && FennecFoxEntity.this.m_217043_().m_188501_() < 0.02f && !FennecFoxEntity.this.m_5803_() && FennecFoxEntity.this.m_5448_() == null && FennecFoxEntity.this.m_21573_().m_26571_() && !this.alertable() && !FennecFoxEntity.this.isPouncing() && !FennecFoxEntity.this.m_6047_();
        }

        public boolean m_8045_() {
            return this.looksRemaining > 0;
        }

        public void m_8056_() {
            this.resetLook();
            this.looksRemaining = 2 + FennecFoxEntity.this.m_217043_().m_188503_(3);
            FennecFoxEntity.this.setSitting(true);
            FennecFoxEntity.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            FennecFoxEntity.this.setSitting(false);
        }

        public void m_8037_() {
            --this.lookTime;
            if (this.lookTime <= 0) {
                --this.looksRemaining;
                this.resetLook();
            }
            FennecFoxEntity.this.m_21563_().m_24950_(FennecFoxEntity.this.m_20185_() + this.relX, FennecFoxEntity.this.m_20188_(), FennecFoxEntity.this.m_20189_() + this.relZ, (float)FennecFoxEntity.this.m_8085_(), (float)FennecFoxEntity.this.m_8132_());
        }

        private void resetLook() {
            double d0 = Math.PI * 2 * FennecFoxEntity.this.m_217043_().m_188500_();
            this.relX = Math.cos(d0);
            this.relZ = Math.sin(d0);
            this.lookTime = this.m_183277_(80 + FennecFoxEntity.this.m_217043_().m_188503_(20));
        }
    }

    class DefendTrustedTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        @Nullable
        private LivingEntity trustedLastHurtBy;
        @Nullable
        private LivingEntity trustedLastHurt;
        private int timestamp;

        public DefendTrustedTargetGoal(Class<LivingEntity> p_28634_, boolean p_28635_, @Nullable boolean p_28636_, Predicate<LivingEntity> p_28637_) {
            super((Mob)FennecFoxEntity.this, p_28634_, 10, p_28635_, p_28636_, p_28637_);
        }

        public boolean m_8036_() {
            if (this.f_26049_ > 0 && this.f_26135_.m_217043_().m_188503_(this.f_26049_) != 0) {
                return false;
            }
            for (UUID uuid : FennecFoxEntity.this.getTrustedUUIDs()) {
                LivingEntity livingentity;
                Entity entity;
                if (uuid == null || !(FennecFoxEntity.this.m_9236_() instanceof ServerLevel) || !((entity = ((ServerLevel)FennecFoxEntity.this.m_9236_()).m_8791_(uuid)) instanceof LivingEntity)) continue;
                this.trustedLastHurt = livingentity = (LivingEntity)entity;
                this.trustedLastHurtBy = livingentity.m_21188_();
                int i = livingentity.m_21213_();
                return i != this.timestamp && this.m_26150_(this.trustedLastHurtBy, this.f_26051_);
            }
            return false;
        }

        public void m_8056_() {
            this.m_26070_(this.trustedLastHurtBy);
            this.f_26050_ = this.trustedLastHurtBy;
            if (this.trustedLastHurt != null) {
                this.timestamp = this.trustedLastHurt.m_21213_();
            }
            FennecFoxEntity.this.m_5496_(SoundEvents.f_11943_, 1.0f, 1.0f);
            FennecFoxEntity.this.setDefending(true);
            FennecFoxEntity.this.wakeUp();
            super.m_8056_();
        }
    }

    public static enum Type implements StringRepresentable
    {
        RED(0, "red"),
        SNOW(1, "snow");

        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;
        private final int id;
        private final String name;

        private Type(int p_196658_, String p_196659_) {
            this.id = p_196658_;
            this.name = p_196659_;
        }

        public String m_7912_() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static Type byName(String p_28817_) {
            return (Type)CODEC.m_262792_(p_28817_, (Enum)RED);
        }

        public static Type byId(int p_28813_) {
            return BY_ID.apply(p_28813_);
        }

        public static Type byBiome(Holder<Biome> p_204063_) {
            return p_204063_.m_203656_(BiomeTags.f_263748_) ? SNOW : RED;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
            BY_ID = ByIdMap.m_262839_(Type::getId, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    public static class FoxGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Type type;

        public FoxGroupData(Type p_28703_) {
            super(false);
            this.type = p_28703_;
        }
    }

    abstract class FoxBehaviorGoal
    extends Goal {
        private final TargetingConditions alertableTargeting;

        FoxBehaviorGoal() {
            this.alertableTargeting = TargetingConditions.m_148352_().m_26883_(12.0).m_148355_().m_26888_((Predicate)new FoxAlertableEntitiesSelector());
        }

        protected boolean hasShelter() {
            BlockPos blockpos = BlockPos.m_274561_((double)FennecFoxEntity.this.m_20185_(), (double)FennecFoxEntity.this.m_20191_().f_82292_, (double)FennecFoxEntity.this.m_20189_());
            return !FennecFoxEntity.this.m_9236_().m_45527_(blockpos) && FennecFoxEntity.this.m_21692_(blockpos) >= 0.0f;
        }

        protected boolean alertable() {
            return !FennecFoxEntity.this.m_9236_().m_45971_(LivingEntity.class, this.alertableTargeting, (LivingEntity)FennecFoxEntity.this, FennecFoxEntity.this.m_20191_().m_82377_(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class FoxAlertableEntitiesSelector
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity p_28653_) {
            if (p_28653_ instanceof Fox) {
                return false;
            }
            if (!(p_28653_ instanceof Chicken || p_28653_ instanceof Rabbit || p_28653_ instanceof Monster)) {
                if (p_28653_ instanceof TamableAnimal) {
                    return !((TamableAnimal)p_28653_).m_21824_();
                }
                if (!(p_28653_ instanceof Player) || !p_28653_.m_5833_() && !((Player)p_28653_).m_7500_()) {
                    if (FennecFoxEntity.this.trusts(p_28653_.m_20148_())) {
                        return false;
                    }
                    return !p_28653_.m_5803_() && !p_28653_.m_20163_();
                }
                return false;
            }
            return true;
        }
    }
}

