/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.mixin;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WanderingTraderSpawner.class})
public class WanderingTraderEventMixin {
    private RandomSource random = RandomSource.m_216327_();
    @Final
    private ServerLevelData serverLevelData;

    @Inject(method={"spawn"}, at={@At(value="HEAD")}, cancellable=true)
    private boolean spawn(ServerLevel p_35916_, CallbackInfoReturnable info) {
        ServerPlayer player = p_35916_.m_8890_();
        if (player == null) {
            return true;
        }
        if (this.random.m_188503_(10) != 0) {
            return false;
        }
        BlockPos blockpos = player.m_20183_();
        int i = 48;
        PoiManager poimanager = p_35916_.m_8904_();
        Optional optional = poimanager.m_27186_(p_219713_ -> p_219713_.m_203565_(PoiTypes.f_218061_), p_219711_ -> true, blockpos, 48, PoiManager.Occupancy.ANY);
        BlockPos blockpos1 = optional.orElse(blockpos);
        BlockPos blockpos2 = this.findSpawnPositionNear((LevelReader)p_35916_, blockpos1, 48);
        if (blockpos2 != null && this.hasEnoughSpace((BlockGetter)p_35916_, blockpos2)) {
            if (p_35916_.m_204166_(blockpos2).m_203656_(BiomeTags.f_215807_)) {
                return false;
            }
            WanderingTrader wanderingtrader = (WanderingTrader)EntityType.f_20494_.m_262496_(p_35916_, blockpos2, MobSpawnType.EVENT);
            if (wanderingtrader != null) {
                for (int j = 0; j < 2; ++j) {
                    if (!p_35916_.m_204166_(blockpos2).m_203565_(Biomes.f_48203_)) {
                        this.tryToSpawnCamelFor(p_35916_, wanderingtrader, 4);
                        continue;
                    }
                    this.tryToSpawnLlamaFor(p_35916_, wanderingtrader, 4);
                }
                this.serverLevelData.m_8115_(wanderingtrader.m_20148_());
                wanderingtrader.m_35891_(48000);
                wanderingtrader.m_35883_(blockpos1);
                wanderingtrader.m_21446_(blockpos1, 16);
                return true;
            }
        }
        return false;
    }

    private void tryToSpawnLlamaFor(ServerLevel p_35918_, WanderingTrader p_35919_, int p_35920_) {
        TraderLlama traderllama;
        BlockPos blockpos = this.findSpawnPositionNear((LevelReader)p_35918_, p_35919_.m_20183_(), p_35920_);
        if (blockpos != null && (traderllama = (TraderLlama)EntityType.f_20488_.m_262496_(p_35918_, blockpos, MobSpawnType.EVENT)) != null) {
            traderllama.m_21463_((Entity)p_35919_, true);
        }
    }

    private void tryToSpawnCamelFor(ServerLevel p_35918_, WanderingTrader p_35919_, int p_35920_) {
        Camel traderllama;
        BlockPos blockpos = this.findSpawnPositionNear((LevelReader)p_35918_, p_35919_.m_20183_(), p_35920_);
        if (blockpos != null && (traderllama = (Camel)EntityType.f_243976_.m_262496_(p_35918_, blockpos, MobSpawnType.EVENT)) != null) {
            traderllama.m_21463_((Entity)p_35919_, true);
        }
    }

    @Nullable
    private BlockPos findSpawnPositionNear(LevelReader p_35929_, BlockPos p_35930_, int p_35931_) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = p_35930_.m_123341_() + this.random.m_188503_(p_35931_ * 2) - p_35931_;
            BlockPos blockpos1 = new BlockPos(j, l = p_35929_.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = p_35930_.m_123343_() + this.random.m_188503_(p_35931_ * 2) - p_35931_), k);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)p_35929_, (BlockPos)blockpos1, (EntityType)EntityType.f_20494_)) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean hasEnoughSpace(BlockGetter p_35926_, BlockPos p_35927_) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)p_35927_, (BlockPos)p_35927_.m_7918_(1, 2, 1))) {
            if (p_35926_.m_8055_(blockpos).m_60812_(p_35926_, blockpos).m_83281_()) continue;
            return false;
        }
        return true;
    }
}

