/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.atlas;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.lopymine.ip.InventoryParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;

public class InventoryParticlesAtlasManager {
    public static final Identifier ATLAS_ID = InventoryParticles.id("textures/atlas/iparticles");
    public static final Identifier FOLDER_ID = InventoryParticles.id("iparticles");
    private static InventoryParticlesAtlasManager INSTANCE;
    private final TextureAtlas atlas = new TextureAtlas(ATLAS_ID);

    public InventoryParticlesAtlasManager() {
        Minecraft.getInstance().getTextureManager().register(ATLAS_ID, (AbstractTexture)this.atlas);
    }

    public static InventoryParticlesAtlasManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InventoryParticlesAtlasManager();
            return INSTANCE;
        }
        return INSTANCE;
    }

    public void reload(PreparableReloadListener.PreparationBarrier synchronizer, ResourceManager resourceManager, Executor prepareExecutor, Executor applyExecutor) {
        ((CompletableFuture)SpriteLoader.create((TextureAtlas)this.atlas).loadAndStitch(resourceManager, FOLDER_ID, 0, prepareExecutor, Set.of()).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)synchronizer).wait(arg_0))).thenAcceptAsync(arg_0 -> ((TextureAtlas)this.atlas).upload(arg_0), applyExecutor);
    }

    public void close() {
        this.atlas.close();
    }

    public TextureAtlasSprite getSprite(Identifier id) {
        return this.atlas.getSprite(id);
    }

    public TextureAtlasSprite getMissingSprite() {
        return this.atlas.missingSprite;
    }
}

