/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.color.advanced;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import net.lopymine.ip.color.IListParticleColorType;
import net.lopymine.ip.color.IParticleColorType;
import net.lopymine.ip.color.advanced.mode.IAdvancedParticleColorTypeMode;
import net.lopymine.ip.debug.HideInDebugRender;
import net.lopymine.mossylib.utils.CodecUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AdvancedParticleColorType
implements IParticleColorType {
    @HideInDebugRender
    public static final Codec<AdvancedParticleColorType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.option((String)"mode", (Object)"random_static", (Codec)Codec.STRING, type -> type.getMode().asString()), (App)CodecUtils.option((String)"values", new ArrayList(), (Codec)IParticleColorType.CODEC.listOf(), AdvancedParticleColorType::getValues), (App)CodecUtils.option((String)"speed", (Object)0, (Codec)Codec.INT, AdvancedParticleColorType::getSpeed)).apply((Applicative)instance, AdvancedParticleColorType::new));
    private IAdvancedParticleColorTypeMode mode;
    private List<IParticleColorType> values;
    @Nullable
    private Integer[] compiledValues;
    private int speed;

    public AdvancedParticleColorType(IAdvancedParticleColorTypeMode mode, List<IParticleColorType> values, int speed) {
        this.mode = mode;
        this.values = values;
        this.speed = speed;
    }

    public AdvancedParticleColorType(String mode, List<IParticleColorType> values, int speed) {
        this.mode = IAdvancedParticleColorTypeMode.parse(mode, speed);
        this.values = values;
        this.speed = speed;
    }

    @Override
    public IParticleColorType copy() {
        return new AdvancedParticleColorType(this.mode.copy(), this.values, this.speed);
    }

    @Override
    public int tick(RandomSource random) {
        if (this.compiledValues.length == 0) {
            return -1;
        }
        return this.mode.tickResolve(this.compiledValues, random);
    }

    @Override
    public void compile(ItemStack stack, RandomSource random) {
        ArrayList<Integer> compiledColors = new ArrayList<Integer>();
        for (IParticleColorType type : this.values) {
            type.compile(stack, random);
            if (type instanceof IListParticleColorType) {
                IListParticleColorType listType = (IListParticleColorType)((Object)type);
                compiledColors.addAll(Arrays.asList(listType.getList()));
                continue;
            }
            compiledColors.add(type.tick(random));
        }
        this.compiledValues = (Integer[])compiledColors.toArray(Integer[]::new);
    }

    @Override
    public String asString() {
        return "advanced";
    }

    public String toString() {
        return this.asString();
    }

    @Generated
    public IAdvancedParticleColorTypeMode getMode() {
        return this.mode;
    }

    @Generated
    public List<IParticleColorType> getValues() {
        return this.values;
    }

    @Nullable
    @Generated
    public Integer[] getCompiledValues() {
        return this.compiledValues;
    }

    @Generated
    public int getSpeed() {
        return this.speed;
    }

    @Generated
    public void setMode(IAdvancedParticleColorTypeMode mode) {
        this.mode = mode;
    }

    @Generated
    public void setValues(List<IParticleColorType> values) {
        this.values = values;
    }

    @Generated
    public void setCompiledValues(@Nullable Integer[] compiledValues) {
        this.compiledValues = compiledValues;
    }

    @Generated
    public void setSpeed(int speed) {
        this.speed = speed;
    }
}

