/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.element;

import lombok.Generated;
import net.lopymine.ip.element.base.TickElement;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class InventoryCursor
extends TickElement {
    private ItemStack currentStack = Items.AIR.getDefaultInstance();
    @Nullable
    private Slot hoveredSlot = null;
    private double lastSpeed = 0.0;
    private double speed = 0.0;
    private int lastX = 0;
    private int x = 0;
    private int lastY = 0;
    private int y = 0;
    private int mouseX = 0;
    private int mouseY = 0;

    public void setCurrentStack(@Nullable ItemStack currentStack) {
        this.currentStack = currentStack == null || currentStack == ItemStack.EMPTY ? Items.AIR.getDefaultInstance() : currentStack;
    }

    public void setX(int x) {
        this.lastX = this.x;
        this.x = x;
    }

    public void setY(int y) {
        this.lastY = this.y;
        this.y = y;
    }

    public void setSpeed(double speed) {
        this.lastSpeed = this.speed;
        this.speed = speed;
    }

    public int getDeltaX() {
        return Math.abs(this.x - this.lastX);
    }

    public int getDeltaY() {
        return Math.abs(this.y - this.lastY);
    }

    public double getSpeedX() {
        double rawCursorSpeedX = this.x - this.lastX;
        int directionalX = rawCursorSpeedX < 0.0 ? -1 : 1;
        return Math.sqrt(Math.abs(rawCursorSpeedX)) * (double)directionalX;
    }

    public double getSpeedY() {
        double rawCursorSpeedY = this.y - this.lastY;
        int directionalY = rawCursorSpeedY < 0.0 ? -1 : 1;
        return Math.sqrt(Math.abs(rawCursorSpeedY)) * (double)directionalY;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticks == 1) {
            this.x = this.getMouseX();
            this.y = this.getMouseY();
            this.lastX = this.x;
            this.lastY = this.y;
        } else {
            this.setX(this.getMouseX());
            this.setY(this.getMouseY());
        }
        double speed = Math.sqrt(Math.pow(this.getDeltaX(), 2.0) + Math.pow(this.getDeltaY(), 2.0));
        this.setSpeed(speed);
    }

    @Generated
    public void setHoveredSlot(@Nullable Slot hoveredSlot) {
        this.hoveredSlot = hoveredSlot;
    }

    @Generated
    public void setLastSpeed(double lastSpeed) {
        this.lastSpeed = lastSpeed;
    }

    @Generated
    public void setLastX(int lastX) {
        this.lastX = lastX;
    }

    @Generated
    public void setLastY(int lastY) {
        this.lastY = lastY;
    }

    @Generated
    public void setMouseX(int mouseX) {
        this.mouseX = mouseX;
    }

    @Generated
    public void setMouseY(int mouseY) {
        this.mouseY = mouseY;
    }

    @Generated
    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    @Nullable
    @Generated
    public Slot getHoveredSlot() {
        return this.hoveredSlot;
    }

    @Generated
    public double getLastSpeed() {
        return this.lastSpeed;
    }

    @Generated
    public double getSpeed() {
        return this.speed;
    }

    @Generated
    public int getLastX() {
        return this.lastX;
    }

    @Generated
    public int getX() {
        return this.x;
    }

    @Generated
    public int getLastY() {
        return this.lastY;
    }

    @Generated
    public int getY() {
        return this.y;
    }

    @Generated
    public int getMouseX() {
        return this.mouseX;
    }

    @Generated
    public int getMouseY() {
        return this.mouseY;
    }
}

