/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.mixin;

import net.lopymine.ip.client.InventoryParticlesClient;
import net.lopymine.ip.config.InventoryParticlesConfig;
import net.lopymine.ip.config.sub.InventoryParticlesMainConfig;
import net.lopymine.ip.renderer.InventoryParticlesRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Screen.class})
public class ScreenMixin {
    @Shadow
    public int width;
    @Shadow
    public int height;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.AFTER)}, method={"renderWithTooltipAndSubtitles"})
    private void renderInventoryParticles(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        InventoryParticlesMainConfig config = InventoryParticlesConfig.getInstance().getMainConfig();
        if (!config.isModEnabled()) {
            return;
        }
        Screen screen = (Screen)this;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen handledScreen = (AbstractContainerScreen)screen;
            InventoryParticlesRenderer.getInstance().updateCursor(mouseY, mouseX, handledScreen.getMenu().getCarried(), handledScreen.hoveredSlot);
        }
        float tickProgress = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true);
        InventoryParticlesRenderer.getInstance().render(context, tickProgress);
        if (!config.isDebugModeEnabled()) {
            return;
        }
        context.nextStratum();
        InventoryParticlesClient.DEBUG_CURSOR_INFO_RENDERER.render(context);
        InventoryParticlesClient.DEBUG_PARTICLE_INFO_RENDERER.render(context);
        context.nextStratum();
    }
}

