/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.predicate.nbt.debug;

import lombok.Generated;
import net.lopymine.ip.predicate.nbt.NbtNode;
import net.lopymine.ip.predicate.nbt.NbtNodeType;
import org.jetbrains.annotations.Nullable;

public class DebugNbtPath {
    private String name;
    private NbtNodeType type;
    @Nullable
    private DebugNbtPath parent;

    private DebugNbtPath(String name, NbtNodeType type) {
        this.name = name;
        this.type = type;
    }

    public static DebugNbtPath create(NbtNode node) {
        return new DebugNbtPath(node.getName(), node.getType());
    }

    public void next(NbtNode next) {
        String name = this.getName();
        NbtNodeType type = this.getType();
        DebugNbtPath parent = this.getParent();
        DebugNbtPath path = new DebugNbtPath(name, type, parent);
        this.setName(next.getName());
        this.setType(next.getType());
        this.setParent(path);
    }

    public void back() {
        DebugNbtPath parent = this.getParent();
        if (parent == null) {
            return;
        }
        this.setName(parent.getName());
        this.setType(parent.getType());
        this.setParent(parent.getParent());
    }

    public String toString() {
        Object string = this.asString();
        if (this.parent != null) {
            String parentString = this.parent.toString();
            string = parentString + " \u2014> " + (String)string;
        }
        return string;
    }

    public String asString() {
        return "%s[%s]".formatted(this.name, this.type.getSerializedName());
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(NbtNodeType type) {
        this.type = type;
    }

    @Generated
    public void setParent(@Nullable DebugNbtPath parent) {
        this.parent = parent;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public NbtNodeType getType() {
        return this.type;
    }

    @Nullable
    @Generated
    public DebugNbtPath getParent() {
        return this.parent;
    }

    @Generated
    public DebugNbtPath(String name, NbtNodeType type, @Nullable DebugNbtPath parent) {
        this.name = name;
        this.type = type;
        this.parent = parent;
    }
}

