/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.texture;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lopymine.ip.atlas.InventoryParticlesAtlasManager;
import net.lopymine.ip.config.particle.ParticleAnimationType;
import net.lopymine.ip.config.particle.ParticleConfig;
import net.lopymine.ip.debug.IDebugRenderable;
import net.lopymine.ip.element.base.ITickElement;
import net.lopymine.ip.texture.LoopParticleTextureProvider;
import net.lopymine.ip.texture.OneTimeParticleTextureProvider;
import net.lopymine.ip.texture.RandomParticleTextureProvider;
import net.lopymine.ip.texture.RandomStaticParticleTextureProvider;
import net.lopymine.ip.texture.StretchParticleTextureProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;

public interface IParticleTextureProvider
extends ITickElement,
IDebugRenderable {
    public static final Map<ParticleConfig, List<TextureAtlasSprite>> CACHED_SPRITES = new HashMap<ParticleConfig, List<TextureAtlasSprite>>();

    public static void clear() {
        CACHED_SPRITES.clear();
    }

    public static IParticleTextureProvider getTextureProvider(ParticleConfig config) {
        List sprites = CACHED_SPRITES.computeIfAbsent(config, cfg -> {
            ArrayList<Identifier> textures = config.getTextures();
            return textures.stream().map(InventoryParticlesAtlasManager.getInstance()::getSprite).toList();
        });
        double animationSpeed = config.getAnimationSpeed();
        int lifeTime = config.getLifeTimeTicks();
        return switch (config.getAnimationType()) {
            default -> throw new MatchException(null, null);
            case ParticleAnimationType.STRETCH -> new StretchParticleTextureProvider(sprites, animationSpeed, lifeTime);
            case ParticleAnimationType.ONETIME -> new OneTimeParticleTextureProvider(sprites, animationSpeed, lifeTime);
            case ParticleAnimationType.LOOP -> new LoopParticleTextureProvider(sprites, animationSpeed, lifeTime);
            case ParticleAnimationType.RANDOM -> new RandomParticleTextureProvider(sprites, animationSpeed, lifeTime);
            case ParticleAnimationType.RANDOM_STATIC -> new RandomStaticParticleTextureProvider(sprites, animationSpeed, lifeTime);
        };
    }

    public TextureAtlasSprite getInitializationTexture(RandomSource var1);

    public TextureAtlasSprite getTexture(RandomSource var1);

    public boolean isShouldDead();
}

