/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mossylib.gui;

import net.lopymine.mossylib.MossyLib;
import net.lopymine.mossylib.extension.DrawContextExtension;
import net.lopymine.mossylib.gui.TransparencySprites;
import net.lopymine.mossylib.utils.DrawUtils;
import net.lopymine.mossylib.utils.RenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.Identifier;

public class BackgroundRenderer {
    public static void drawWidgetBackground(GuiGraphics context, int x, int y, int width, int height, boolean enabled, boolean hovered) {
        BackgroundRenderer.drawWidgetBackground(context, x, y, width, height, enabled, hovered, false);
    }

    public static void drawWidgetBackground(GuiGraphics context, int x, int y, int width, int height, boolean enabled, boolean hovered, boolean rotate) {
        if (!enabled) {
            DrawUtils.drawGuiTexture(context, MossyLib.spriteId("transparency/widget/disabled_widget"), x, y, width, height);
            return;
        }
        DrawContextExtension.push(context);
        DrawContextExtension.translate(context, x, y, 0.0f);
        if (rotate) {
            DrawContextExtension.rotateZ(context, 180.0f);
            DrawContextExtension.translate(context, -width, -height, 0.0f);
        }
        if (hovered) {
            DrawUtils.drawGuiTexture(context, MossyLib.spriteId("transparency/widget/hovered_widget"), 0, 0, width, height);
        } else {
            DrawUtils.drawGuiTexture(context, MossyLib.spriteId("transparency/widget/widget"), 0, 0, width, height);
        }
        DrawContextExtension.pop(context);
    }

    public static void drawTransparencyBackground(GuiGraphics context, int x, int y, int width, int height, boolean list) {
        BackgroundRenderer.drawTransparencyBackground(context, x, y, width, height, list, true, true, true, true);
    }

    public static void drawTransparencyBackground(GuiGraphics context, int x, int y, int width, int height, boolean list, boolean up) {
        BackgroundRenderer.drawTransparencyBackground(context, x, y, width, height, list, up, true, true, true);
    }

    public static void drawTransparencyBackground(GuiGraphics context, int x, int y, int width, int height, boolean list, boolean up, boolean bottom) {
        BackgroundRenderer.drawTransparencyBackground(context, x, y, width, height, list, up, bottom, true, true);
    }

    public static void drawTransparencyBackground(GuiGraphics context, int x, int y, int width, int height, boolean list, boolean up, boolean bottom, boolean right) {
        BackgroundRenderer.drawTransparencyBackground(context, x, y, width, height, list, up, bottom, right, true);
    }

    public static void drawTransparencyBackground(GuiGraphics context, int x, int y, int width, int height, boolean list, boolean up, boolean bottom, boolean right, boolean left) {
        Identifier menuBackgroundTexture = list ? TransparencySprites.getMenuListBackgroundTexture() : TransparencySprites.getMenuBackgroundTexture();
        Identifier menuSeparatorTexture = TransparencySprites.getMenuSeparatorTexture();
        BackgroundRenderer.drawTransparencyBackground(context, x, y, width, height, menuBackgroundTexture, menuSeparatorTexture, up, bottom, right, left);
    }

    public static void drawTransparencyBackground(GuiGraphics context, int x, int y, int width, int height, Identifier backgroundTexture, Identifier separatorTexture, boolean up, boolean bottom, boolean right, boolean left) {
        RenderUtils.enableBlend();
        DrawUtils.drawTexture(context, backgroundTexture, x + 2, y + 2, 0.0f, 0.0f, width - 4, height - 4, 32, 32);
        if (up) {
            DrawUtils.drawTexture(context, separatorTexture, x + 2, y, 0.0f, 0.0f, width - 4, 2, 32, 2);
        }
        if (bottom) {
            DrawContextExtension.push(context);
            DrawContextExtension.translate(context, x + width - 2, y + height, 0.0f);
            DrawContextExtension.rotateZ(context, 180.0f);
            DrawUtils.drawTexture(context, separatorTexture, 0, 0, 0.0f, 0.0f, width - 4, 2, 32, 2);
            DrawContextExtension.pop(context);
        }
        if (right) {
            DrawContextExtension.push(context);
            DrawContextExtension.translate(context, x + width, y + 1, 0.0f);
            DrawContextExtension.rotateZ(context, 90.0f);
            DrawUtils.drawTexture(context, separatorTexture, 0, 0, 0.0f, 0.0f, height - 2, 2, 32, 2);
            DrawContextExtension.pop(context);
        }
        if (left) {
            DrawContextExtension.push(context);
            DrawContextExtension.translate(context, x, y + height - 1, 0.0f);
            DrawContextExtension.rotateZ(context, -90.0f);
            DrawUtils.drawTexture(context, separatorTexture, 0, 0, 0.0f, 0.0f, height - 2, 2, 32, 2);
            DrawContextExtension.pop(context);
        }
        if (up && left) {
            DrawUtils.drawTexture(context, separatorTexture, x, y, 0.0f, 0.0f, 2, 1, 1, 0);
        }
        if (up && right) {
            DrawUtils.drawTexture(context, separatorTexture, x + width - 2, y, 0.0f, 0.0f, 2, 1, 1, 0);
        }
        if (bottom && left) {
            DrawUtils.drawTexture(context, separatorTexture, x, y + height - 1, 0.0f, 0.0f, 2, 1, 1, 0);
        }
        if (bottom && right) {
            DrawUtils.drawTexture(context, separatorTexture, x + width - 2, y + height - 1, 0.0f, 0.0f, 2, 1, 1, 0);
        }
        RenderUtils.disableBlend();
    }
}

