/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mossylib.modmenu;

import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;
import net.lopymine.mossylib.client.MossyLibClient;
import net.lopymine.mossylib.utils.ModMenuUtils;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Util;
import org.jetbrains.annotations.NotNull;

public class NoConfigLibraryScreen {
    private static final Set<String> ALLOWED_PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});
    private static final String YACL_MODRINTH_LINK = "https://modrinth.com/mod/yacl/versions?l=fabric&g=";

    private NoConfigLibraryScreen() {
        throw new IllegalStateException("Screen class, use createScreen(...) method!");
    }

    @NotNull
    public static Screen createScreen(Screen parent, String modId) {
        return new ConfirmScreen(open -> NoConfigLibraryScreen.onConfirm(open, parent), ModMenuUtils.getModTitle(modId), (Component)ModMenuUtils.getNoConfigScreenMessage(), CommonComponents.GUI_CONTINUE, CommonComponents.GUI_BACK);
    }

    private static void onConfirm(boolean open, Screen parent) {
        if (open) {
            try {
                String url = YACL_MODRINTH_LINK + SharedConstants.getCurrentVersion().name();
                URI link = new URI(url);
                String string = link.getScheme();
                if (string == null) {
                    throw new URISyntaxException(url, "Missing protocol");
                }
                if (!ALLOWED_PROTOCOLS.contains(string.toLowerCase(Locale.ROOT))) {
                    throw new URISyntaxException(url, "Unsupported protocol: " + string.toLowerCase(Locale.ROOT));
                }
                Util.getPlatform().openUri(link);
            }
            catch (URISyntaxException e) {
                MossyLibClient.LOGGER.error("Can't open YACL Modrinth page:", e);
            }
        } else {
            Minecraft.getInstance().setScreen(parent);
        }
    }

    public static Screen createScreenAboutOldVersion(Screen parent, String version, String modId) {
        return new ConfirmScreen(open -> NoConfigLibraryScreen.onConfirm(open, parent), ModMenuUtils.getModTitle(modId), (Component)ModMenuUtils.getOldConfigScreenMessage(version), CommonComponents.GUI_CONTINUE, CommonComponents.GUI_BACK);
    }
}

