/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mossylib.utils;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class DrawUtils {
    public static void drawGuiTexture(GuiGraphics context, ResourceLocation sprite, int x, int y, int width, int height) {
        context.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, x, y, width, height);
    }

    public static void drawTexture(GuiGraphics context, ResourceLocation sprite, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        context.blit(RenderPipelines.GUI_TEXTURED, sprite, x, y, u, v, width, height, textureWidth, textureHeight);
    }

    public static void drawTooltip(GuiGraphics context, List<ClientTooltipComponent> list, int x, int y) {
        context.renderTooltip(Minecraft.getInstance().font, list, x, y, DefaultTooltipPositioner.INSTANCE, null);
    }

    public static void drawCenteredText(GuiGraphics context, int x, int y, int width, Component text) {
        DrawUtils.drawCenteredText(context, text, x, y, width);
    }

    public static void drawText(GuiGraphics context, int x, int y, int width, Component text) {
        DrawUtils.drawText(context, text, x, y, width, 0);
    }

    public static void drawCenteredText(GuiGraphics context, Component text, int x, int y, int width) {
        DrawUtils.drawCenteredText(context, text, x, y, width, 0);
    }

    public static void drawCenteredText(GuiGraphics context, Component text, int x, int y, int width, int height) {
        Font textRenderer = Minecraft.getInstance().font;
        int textWidth = textRenderer.width((FormattedText)text);
        int centerX = x + width / 2;
        int start = centerX - textWidth / 2;
        int end = centerX + textWidth / 2;
        if (start < x || end > x + width) {
            DrawUtils.drawScrollableText(context, x, y, width, height, text);
        } else {
            int n = y + height / 2;
            Objects.requireNonNull(textRenderer);
            context.drawString(textRenderer, text, start, n - 9 / 2, -1, true);
        }
    }

    public static void drawText(GuiGraphics context, Component text, int x, int y, int width) {
        DrawUtils.drawText(context, text, x, y, width, 0);
    }

    public static void drawText(GuiGraphics context, Component text, int x, int y, int width, int height) {
        Font textRenderer = Minecraft.getInstance().font;
        int textWidth = textRenderer.width((FormattedText)text);
        if (x + textWidth > x + width) {
            DrawUtils.drawScrollableText(context, x, y, width, height, text);
        } else {
            int n = y + height / 2;
            Objects.requireNonNull(textRenderer);
            context.drawString(textRenderer, text, x, n - 9 / 2, -1, true);
        }
    }

    private static void drawScrollableText(GuiGraphics context, int x, int y, int width, int height, Component text) {
        Font textRenderer = Minecraft.getInstance().font;
        AbstractWidget.renderScrollingString((GuiGraphics)context, (Font)textRenderer, (Component)text, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-1);
    }
}

