/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.client.renderer;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.lopymine.ip.client.InventoryParticlesClient;
import net.lopymine.ip.debug.HideInDebugRender;
import net.lopymine.ip.debug.IDebugRenderable;
import net.lopymine.ip.debug.ISpecialFieldDebugRenderer;
import net.lopymine.ip.utils.ArgbUtils2;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public abstract class AbstractDebugInfoRenderer {
    private final Map<String, ISpecialFieldDebugRenderer> specialFieldRenderers = new HashMap<String, ISpecialFieldDebugRenderer>();
    private String lastError;
    protected int yOffset = 5;
    protected int xOffset = 5;

    protected void registerSpecialFieldDebugRenderer(String name, ISpecialFieldDebugRenderer renderable) {
        this.specialFieldRenderers.put(name, renderable);
    }

    public void render(GuiGraphics context, Class<?> clazz, Object clazzInstance) {
        this.yOffset = 5;
        this.xOffset = 5;
        this.renderDecoration(context, "[" + this.getRendererName() + "]");
        this.renderClassFields(context, clazz, clazzInstance, (name, value) -> this.renderFieldData(context, (String)name, value), decoration -> this.renderDecoration(context, (String)decoration));
    }

    private void renderClassFields(GuiGraphics context, Class<?> clazz, Object clazzInstance, BiConsumer<String, Object> renderFieldData, Consumer<String> renderDecoration) {
        Stream.Builder<Field> builder = Stream.builder();
        Class<?> c = clazz;
        do {
            for (Field field2 : c.getDeclaredFields()) {
                builder.add(field2);
            }
        } while ((c = c.getSuperclass()) != null);
        builder.build().filter(field -> {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                return false;
            }
            return !field.isAnnotationPresent(HideInDebugRender.class);
        }).forEach(field -> {
            block5: {
                try {
                    String name = field.getName();
                    field.setAccessible(true);
                    Object value = field.get(clazzInstance);
                    if (value instanceof IDebugRenderable) {
                        renderDecoration.accept("%s[%s]".formatted(value.getClass().getSimpleName(), name));
                        this.xOffset += this.getTextXOffset();
                        this.renderClassFields(context, value.getClass(), value, renderFieldData, renderDecoration);
                        this.xOffset -= this.getTextXOffset();
                        return;
                    }
                    ISpecialFieldDebugRenderer specialFieldRenderer = this.specialFieldRenderers.get(name);
                    if (specialFieldRenderer != null) {
                        specialFieldRenderer.consumeDebugRender(renderFieldData, renderDecoration, value);
                    } else {
                        this.renderFieldData(context, name, value);
                    }
                }
                catch (Exception e) {
                    String error = e.toString();
                    if (error.equals(this.lastError)) break block5;
                    this.lastError = error;
                    InventoryParticlesClient.LOGGER.error("Failed to render debug info for field \"{}\" in \"{}\"! Reason:", new Object[]{this.getClass().getSimpleName(), field.getName(), e});
                }
            }
        });
    }

    protected void renderFieldData(GuiGraphics context, String name, Object text) {
        String string = name + ": " + (text == null ? "NULL" : text.toString());
        this.renderLabel(context, string, ChatFormatting.WHITE);
    }

    protected void renderDecoration(GuiGraphics context, String label) {
        this.renderLabel(context, label, ChatFormatting.GRAY);
    }

    protected void renderLabel(GuiGraphics context, String label, ChatFormatting color) {
        Font textRenderer = Minecraft.getInstance().font;
        Screen screen = Minecraft.getInstance().screen;
        if (screen == null) {
            return;
        }
        context.drawString(textRenderer, label, this.getTextX(screen, textRenderer, label), this.getTextY(), color.getColor() == null ? -1 : ArgbUtils2.fullAlpha(color.getColor()), true);
        Objects.requireNonNull(textRenderer);
        this.yOffset += 9 + 1;
    }

    protected int getTextXOffset() {
        return 10;
    }

    protected int getTextY() {
        return this.yOffset;
    }

    protected int getTextX(Screen screen, Font textRenderer, String string) {
        return this.xOffset;
    }

    protected abstract String getRendererName();

    public abstract void render(GuiGraphics var1);
}

