/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.yacl;

import dev.isxander.yacl3.api.Option;
import java.util.function.Function;
import net.lopymine.ip.config.InventoryParticlesConfig;
import net.lopymine.ip.config.optimization.ParticleDeletionMode;
import net.lopymine.ip.config.sub.InventoryParticleConfig;
import net.lopymine.ip.config.sub.InventoryParticlesCoefficientsConfig;
import net.lopymine.ip.config.sub.InventoryParticlesMainConfig;
import net.lopymine.mossylib.utils.ModMenuUtils;
import net.lopymine.mossylib.yacl.api.SimpleCategory;
import net.lopymine.mossylib.yacl.api.SimpleContent;
import net.lopymine.mossylib.yacl.api.SimpleGroup;
import net.lopymine.mossylib.yacl.api.SimpleOption;
import net.lopymine.mossylib.yacl.api.SimpleYACLScreen;
import net.lopymine.mossylib.yacl.extension.SimpleOptionExtension;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class YACLConfigurationScreen {
    private static final Function<Boolean, Component> ENABLED_OR_DISABLE_FORMATTER = ModMenuUtils.getEnabledOrDisabledFormatter();

    private YACLConfigurationScreen() {
        throw new IllegalStateException("Screen class");
    }

    public static Screen createScreen(Screen parent) {
        InventoryParticlesConfig defConfig = InventoryParticlesConfig.getNewInstance();
        InventoryParticlesConfig config = InventoryParticlesConfig.getInstance();
        return SimpleYACLScreen.startBuilder((String)"inventory_particles", (Screen)parent, config::saveAsync).categories(new SimpleCategory[]{YACLConfigurationScreen.getGeneralCategory(defConfig, config)}).build();
    }

    private static SimpleCategory getGeneralCategory(InventoryParticlesConfig defConfig, InventoryParticlesConfig config) {
        return SimpleCategory.startBuilder((String)"general").groups(new SimpleGroup[]{YACLConfigurationScreen.getMainGroup(defConfig.getMainConfig(), config.getMainConfig())}).groups(YACLConfigurationScreen.getParticlesGroups(defConfig, config));
    }

    private static SimpleGroup getMainGroup(InventoryParticlesMainConfig defConfig, InventoryParticlesMainConfig config) {
        SimpleOption.SimpleOptionBuilder[] simpleOptionBuilderArray = new SimpleOption.SimpleOptionBuilder[3];
        simpleOptionBuilderArray[0] = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"mod_enabled").withBinding((Object)defConfig.isModEnabled(), config::isModEnabled, config::setModEnabled, false), ENABLED_OR_DISABLE_FORMATTER).withDescription(SimpleContent.NONE);
        simpleOptionBuilderArray[1] = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"debug_mode_enabled").withBinding((Object)defConfig.isDebugModeEnabled(), config::isDebugModeEnabled, config::setDebugModeEnabled, false), ENABLED_OR_DISABLE_FORMATTER).withDescription(SimpleContent.NONE);
        simpleOptionBuilderArray[2] = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"nbt_debug_mode_enabled").withBinding((Object)defConfig.isNbtDebugModeEnabled(), config::isNbtDebugModeEnabled, config::setNbtDebugModeEnabled, false), ENABLED_OR_DISABLE_FORMATTER).withDescription(SimpleContent.NONE);
        return SimpleGroup.startBuilder((String)"main").options(simpleOptionBuilderArray);
    }

    private static SimpleGroup[] getParticlesGroups(InventoryParticlesConfig defModConfig, InventoryParticlesConfig modConfig) {
        InventoryParticlesCoefficientsConfig defCoefficientConfig = defModConfig.getCoefficientsConfig();
        InventoryParticlesCoefficientsConfig coefficientConfig = modConfig.getCoefficientsConfig();
        SimpleGroup coefficientsGroup = SimpleGroup.startBuilder((String)"coefficients");
        YACLConfigurationScreen.createCoefficientsConfig(coefficientsGroup, "global", defCoefficientConfig.getGlobalConfig(), coefficientConfig.getGlobalConfig());
        Option<?>[] cursorOptions = YACLConfigurationScreen.createCoefficientsConfig(coefficientsGroup, "cursor", defCoefficientConfig.getCursorConfig(), coefficientConfig.getCursorConfig());
        Option<?>[] hoveredSlotOptions = YACLConfigurationScreen.createCoefficientsConfig(coefficientsGroup, "hovered_slot", defCoefficientConfig.getHoveredSlotConfig(), coefficientConfig.getHoveredSlotConfig());
        Option<?>[] guiSlotsOptions = YACLConfigurationScreen.createCoefficientsConfig(coefficientsGroup, "gui_slots", defCoefficientConfig.getAllSlotsConfig(), coefficientConfig.getAllSlotsConfig());
        Option[] optionArray = new Option[2];
        optionArray[0] = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"gui_action_count_coefficient").withBinding((Object)defCoefficientConfig.getGuiActionConfig().getCountCoefficient(), coefficientConfig.getGuiActionConfig()::getCountCoefficient, coefficientConfig.getGuiActionConfig()::setCountCoefficient, true), (double)0.0, (double)50.0, (double)0.1, (boolean)false).withDescription(SimpleContent.NONE).build("inventory_particles");
        optionArray[1] = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"gui_action_spawn_chance").withBinding((Object)defCoefficientConfig.getGuiActionConfig().getCooldownCoefficient(), coefficientConfig.getGuiActionConfig()::getCooldownCoefficient, coefficientConfig.getGuiActionConfig()::setCooldownCoefficient, true), (double)0.0, (double)100.0, (double)0.1, (boolean)false).withDescription(SimpleContent.NONE).build("inventory_particles");
        Option[] guiActionOptions = optionArray;
        coefficientsGroup.options(guiActionOptions);
        InventoryParticleConfig defParticleConfig = defModConfig.getParticleConfig();
        InventoryParticleConfig particleConfig = modConfig.getParticleConfig();
        Option guiActionTakeSpawnEnabled = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"gui_action_take_spawn_enabled").withBinding((Object)defParticleConfig.isGuiActionTakeSpawnEnabled(), particleConfig::isGuiActionTakeSpawnEnabled, particleConfig::setGuiActionTakeSpawnEnabled, true)).withDescription(SimpleContent.NONE).build("inventory_particles");
        Option guiActionPutSpawnEnabled = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"gui_action_put_spawn_enabled").withBinding((Object)defParticleConfig.isGuiActionPutSpawnEnabled(), particleConfig::isGuiActionPutSpawnEnabled, particleConfig::setGuiActionPutSpawnEnabled, true)).withDescription(SimpleContent.NONE).build("inventory_particles");
        Option guiActionQuickMoveSpawnEnabled = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"gui_action_quick_move_spawn_enabled").withBinding((Object)defParticleConfig.isGuiActionQuickMoveSpawnEnabled(), particleConfig::isGuiActionQuickMoveSpawnEnabled, particleConfig::setGuiActionQuickMoveSpawnEnabled, true)).withDescription(SimpleContent.NONE).build("inventory_particles");
        SimpleOption.SimpleOptionBuilder[] simpleOptionBuilderArray = new SimpleOption.SimpleOptionBuilder[7];
        simpleOptionBuilderArray[0] = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"cursor_spawn_enabled").withBinding((Object)defParticleConfig.isCursorSpawnEnabled(), particleConfig::isCursorSpawnEnabled, particleConfig::setCursorSpawnEnabled, true)).withDescription(SimpleContent.NONE).custom(builder -> builder.addListener((o, e) -> {
            for (Option option : cursorOptions) {
                option.setAvailable(((Boolean)o.pendingValue()).booleanValue());
            }
        }));
        simpleOptionBuilderArray[1] = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"hovered_slot_spawn_enabled").withBinding((Object)defParticleConfig.isHoveredSlotSpawnEnabled(), particleConfig::isHoveredSlotSpawnEnabled, particleConfig::setHoveredSlotSpawnEnabled, true)).withDescription(SimpleContent.NONE).custom(builder -> builder.addListener((o, e) -> {
            for (Option option : hoveredSlotOptions) {
                option.setAvailable(((Boolean)o.pendingValue()).booleanValue());
            }
        }));
        simpleOptionBuilderArray[2] = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"gui_slots_spawn_enabled").withBinding((Object)defParticleConfig.isGuiSlotsSpawnEnabled(), particleConfig::isGuiSlotsSpawnEnabled, particleConfig::setGuiSlotsSpawnEnabled, true)).withDescription(SimpleContent.NONE).custom(builder -> builder.addListener((o, e) -> {
            for (Option option : guiSlotsOptions) {
                option.setAvailable(((Boolean)o.pendingValue()).booleanValue());
            }
        }));
        simpleOptionBuilderArray[3] = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"gui_action_spawn_enabled").withBinding((Object)defParticleConfig.isGuiActionSpawnEnabled(), particleConfig::isGuiActionSpawnEnabled, particleConfig::setGuiActionSpawnEnabled, true)).withDescription(SimpleContent.NONE).custom(builder -> builder.addListener((o, e) -> {
            boolean value = (Boolean)o.pendingValue();
            for (Option option : guiActionOptions) {
                option.setAvailable(value);
            }
            guiActionTakeSpawnEnabled.setAvailable(value);
            guiActionPutSpawnEnabled.setAvailable(value);
            guiActionQuickMoveSpawnEnabled.setAvailable(value);
            if (!value) {
                guiActionTakeSpawnEnabled.requestSet((Object)false);
                guiActionPutSpawnEnabled.requestSet((Object)false);
                guiActionQuickMoveSpawnEnabled.requestSet((Object)false);
            }
        }));
        simpleOptionBuilderArray[4] = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"particle_deletion_mode").withBinding((Object)defParticleConfig.getParticleDeletionMode(), particleConfig::getParticleDeletionMode, particleConfig::setParticleDeletionMode, true), ParticleDeletionMode.class).withDescription(SimpleContent.NONE);
        simpleOptionBuilderArray[5] = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"max_particles").withBinding((Object)defParticleConfig.getMaxParticles(), particleConfig::getMaxParticles, particleConfig::setMaxParticles, true), (int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)false).withDescription(SimpleContent.NONE);
        simpleOptionBuilderArray[6] = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)"particle_transparency").withBinding((Object)defParticleConfig.getParticleTransparency(), particleConfig::getParticleTransparency, particleConfig::setParticleTransparency, true), (double)0.0, (double)1.0, (double)0.05).withDescription(SimpleContent.NONE);
        SimpleGroup particlesGroup = SimpleGroup.startBuilder((String)"particles").options(simpleOptionBuilderArray);
        coefficientsGroup.options(new Option[]{guiActionTakeSpawnEnabled, guiActionPutSpawnEnabled, guiActionQuickMoveSpawnEnabled});
        return new SimpleGroup[]{particlesGroup, coefficientsGroup};
    }

    private static Option<?>[] createCoefficientsConfig(SimpleGroup group, String id, InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig defConfig, InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig config) {
        Option[] optionArray = new Option[2];
        optionArray[0] = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)(id + "_count_coefficient")).withBinding((Object)defConfig.getCountCoefficient(), config::getCountCoefficient, config::setCountCoefficient, true), (double)0.0, (double)50.0, (double)0.1, (boolean)false).withDescription(SimpleContent.NONE).build("inventory_particles");
        optionArray[1] = SimpleOptionExtension.withController((SimpleOption.Builder)SimpleOption.startBuilder((String)(id + "_cooldown_coefficient")).withBinding((Object)defConfig.getCooldownCoefficient(), config::getCooldownCoefficient, config::setCooldownCoefficient, true), (double)0.0, (double)50.0, (double)0.1, (boolean)false).withDescription(SimpleContent.NONE).build("inventory_particles");
        Option[] options = optionArray;
        group.options(options);
        return options;
    }
}

