/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.lopymine.ip.config.sub.InventoryParticleConfig;
import net.lopymine.ip.config.sub.InventoryParticlesCoefficientsConfig;
import net.lopymine.ip.config.sub.InventoryParticlesMainConfig;
import net.lopymine.mossylib.loader.MossyLoader;
import net.lopymine.mossylib.utils.CodecUtils;
import net.lopymine.mossylib.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryParticlesConfig {
    public static final Codec<InventoryParticlesConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.option((String)"test_1_2_2", (Object)false, (Codec)Codec.BOOL, InventoryParticlesConfig::isTest122), (App)CodecUtils.option((String)"main", InventoryParticlesMainConfig.getNewInstance(), InventoryParticlesMainConfig.CODEC, InventoryParticlesConfig::getMainConfig), (App)CodecUtils.option((String)"particle", InventoryParticleConfig.getNewInstance(), InventoryParticleConfig.CODEC, InventoryParticlesConfig::getParticleConfig), (App)CodecUtils.option((String)"coefficients", InventoryParticlesCoefficientsConfig.getNewInstance(), InventoryParticlesCoefficientsConfig.CODEC, InventoryParticlesConfig::getCoefficientsConfig)).apply((Applicative)instance, InventoryParticlesConfig::new));
    private static final File CONFIG_FILE = MossyLoader.getConfigDir().resolve("inventory_particles.json5").toFile();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Inventory Particles/Config");
    private static InventoryParticlesConfig INSTANCE;
    private boolean test122;
    private InventoryParticlesMainConfig mainConfig;
    private InventoryParticleConfig particleConfig;
    private InventoryParticlesCoefficientsConfig coefficientsConfig;

    private InventoryParticlesConfig() {
        throw new IllegalArgumentException();
    }

    public static InventoryParticlesConfig getInstance() {
        return INSTANCE == null ? InventoryParticlesConfig.reload() : INSTANCE;
    }

    public static InventoryParticlesConfig reload() {
        INSTANCE = InventoryParticlesConfig.read();
        return INSTANCE;
    }

    public static InventoryParticlesConfig getNewInstance() {
        return (InventoryParticlesConfig)CodecUtils.parseNewInstanceHacky(CODEC);
    }

    private static InventoryParticlesConfig read() {
        InventoryParticlesConfig config = (InventoryParticlesConfig)ConfigUtils.readConfig(CODEC, (File)CONFIG_FILE, (Logger)LOGGER);
        if (!config.isTest122()) {
            config.setTest122(true);
            InventoryParticleConfig particleConfig = config.getParticleConfig();
            particleConfig.setGuiActionSpawnEnabled(true);
            particleConfig.setGuiActionPutSpawnEnabled(true);
            particleConfig.setGuiActionTakeSpawnEnabled(true);
            particleConfig.setGuiActionQuickMoveSpawnEnabled(true);
            config.getCoefficientsConfig().getGuiActionConfig().setCooldownCoefficient(100.0);
            config.saveAsync();
        }
        return config;
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        ConfigUtils.saveConfig((Object)this, CODEC, (File)CONFIG_FILE, (Logger)LOGGER);
    }

    @Generated
    public boolean isTest122() {
        return this.test122;
    }

    @Generated
    public InventoryParticlesMainConfig getMainConfig() {
        return this.mainConfig;
    }

    @Generated
    public InventoryParticleConfig getParticleConfig() {
        return this.particleConfig;
    }

    @Generated
    public InventoryParticlesCoefficientsConfig getCoefficientsConfig() {
        return this.coefficientsConfig;
    }

    @Generated
    public void setTest122(boolean test122) {
        this.test122 = test122;
    }

    @Generated
    public void setMainConfig(InventoryParticlesMainConfig mainConfig) {
        this.mainConfig = mainConfig;
    }

    @Generated
    public void setParticleConfig(InventoryParticleConfig particleConfig) {
        this.particleConfig = particleConfig;
    }

    @Generated
    public void setCoefficientsConfig(InventoryParticlesCoefficientsConfig coefficientsConfig) {
        this.coefficientsConfig = coefficientsConfig;
    }

    @Generated
    public InventoryParticlesConfig(boolean test122, InventoryParticlesMainConfig mainConfig, InventoryParticleConfig particleConfig, InventoryParticlesCoefficientsConfig coefficientsConfig) {
        this.test122 = test122;
        this.mainConfig = mainConfig;
        this.particleConfig = particleConfig;
        this.coefficientsConfig = coefficientsConfig;
    }
}

