/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mossylib.modmenu;

import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;
import net.lopymine.mossylib.client.MossyLibClient;
import net.lopymine.mossylib.utils.ModMenuUtils;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.jetbrains.annotations.NotNull;

public class NoConfigLibraryScreen {
    private static final Set<String> ALLOWED_PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});
    private static final String YACL_MODRINTH_LINK = "https://modrinth.com/mod/yacl/versions?l=fabric&g=";

    private NoConfigLibraryScreen() {
        throw new IllegalStateException("Screen class, use createScreen(...) method!");
    }

    @NotNull
    public static class_437 createScreen(class_437 parent, String modId) {
        return new class_410(open -> NoConfigLibraryScreen.onConfirm(open, parent), ModMenuUtils.getModTitle(modId), (class_2561)ModMenuUtils.getNoConfigScreenMessage(), class_5244.field_41873, class_5244.field_24339);
    }

    private static void onConfirm(boolean open, class_437 parent) {
        if (open) {
            try {
                String url = YACL_MODRINTH_LINK + class_155.method_16673().comp_4025();
                URI link = new URI(url);
                String string = link.getScheme();
                if (string == null) {
                    throw new URISyntaxException(url, "Missing protocol");
                }
                if (!ALLOWED_PROTOCOLS.contains(string.toLowerCase(Locale.ROOT))) {
                    throw new URISyntaxException(url, "Unsupported protocol: " + string.toLowerCase(Locale.ROOT));
                }
                class_156.method_668().method_673(link);
            }
            catch (URISyntaxException e) {
                MossyLibClient.LOGGER.error("Can't open YACL Modrinth page:", e);
            }
        } else {
            class_310.method_1551().method_1507(parent);
        }
    }

    public static class_437 createScreenAboutOldVersion(class_437 parent, String version, String modId) {
        return new class_410(open -> NoConfigLibraryScreen.onConfirm(open, parent), ModMenuUtils.getModTitle(modId), (class_2561)ModMenuUtils.getOldConfigScreenMessage(version), class_5244.field_41873, class_5244.field_24339);
    }
}

