/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mossylib.yacl.api;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.lopymine.mossylib.utils.ModMenuUtils;
import net.lopymine.mossylib.yacl.api.SimpleGroup;
import net.lopymine.mossylib.yacl.api.SimpleOption;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class SimpleCategory {
    private final String categoryId;
    private final List<SimpleGroup> groups = new ArrayList<SimpleGroup>();
    private final List<SimpleOption.SimpleOptionBuilder<?>> options = new ArrayList();
    private Consumer<ConfigCategory.Builder> custom = __ -> {};

    private SimpleCategory(String categoryId) {
        this.categoryId = categoryId;
    }

    public static SimpleCategory startBuilder(String categoryId) {
        return new SimpleCategory(categoryId);
    }

    public SimpleCategory groups(SimpleGroup ... groups) {
        this.groups.addAll(List.of(groups));
        return this;
    }

    public SimpleCategory options(Option<?> ... options) {
        this.custom(builder -> builder.options(List.of(options)));
        return this;
    }

    public SimpleCategory options(SimpleOption.SimpleOptionBuilder<?> ... options) {
        this.options.addAll(List.of(options));
        return this;
    }

    public SimpleCategory custom(Consumer<ConfigCategory.Builder> custom) {
        this.custom = this.custom.andThen(custom);
        return this;
    }

    public ConfigCategory build(String modId) {
        String categoryKey = ModMenuUtils.getCategoryKey(this.categoryId);
        class_5250 categoryName = ModMenuUtils.getName(modId, categoryKey).method_27692(class_124.field_1067);
        ConfigCategory.Builder builder = ConfigCategory.createBuilder();
        for (SimpleOption.SimpleOptionBuilder<?> option : this.options) {
            builder.option(option.build(modId));
        }
        for (SimpleGroup group : this.groups) {
            builder.group(group.build(modId));
        }
        this.custom.accept(builder);
        return builder.name((class_2561)categoryName).build();
    }
}

