/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.config.speed;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Generated;
import net.lopymine.ip.config.range.DoubleRange;
import net.lopymine.mossylib.utils.CodecUtils;
import net.minecraft.util.RandomSource;

public class SpeedConfig {
    public static final Codec<DoubleRange> MAX_CODEC = Codec.either(DoubleRange.CODEC, (Codec)Codec.DOUBLE).xmap(either -> (DoubleRange)either.map(r -> r, f -> new DoubleRange(-f.doubleValue(), (double)f)), Either::left);
    public static final Codec<SpeedConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.option((String)"impulse", (Object)new DoubleRange(), DoubleRange.CODEC, SpeedConfig::getImpulse), (App)CodecUtils.option((String)"impulse_bidirectional", (Object)true, (Codec)Codec.BOOL, SpeedConfig::isImpulseBidirectional), (App)CodecUtils.option((String)"acceleration", (Object)0.0, (Codec)Codec.DOUBLE, SpeedConfig::getAcceleration), (App)CodecUtils.option((String)"acceleration_bidirectional", (Object)true, (Codec)Codec.BOOL, SpeedConfig::isAccelerationBidirectional), (App)CodecUtils.option((String)"max_acceleration", (Object)new DoubleRange(-1.7976931348623157E308, Double.MAX_VALUE), MAX_CODEC, SpeedConfig::getMaxAcceleration), (App)CodecUtils.option((String)"max", (Object)new DoubleRange(-1.7976931348623157E308, Double.MAX_VALUE), MAX_CODEC, SpeedConfig::getMax), (App)CodecUtils.option((String)"braking", (Object)0.0, (Codec)Codec.DOUBLE, SpeedConfig::getBraking), (App)CodecUtils.option((String)"turbulence", (Object)new DoubleRange(), DoubleRange.CODEC, SpeedConfig::getTurbulence), (App)CodecUtils.option((String)"cursor_impulse_inherit_coefficient", (Object)0.0, (Codec)Codec.DOUBLE, SpeedConfig::getCursorImpulseInheritCoefficient)).apply((Applicative)instance, SpeedConfig::new));
    private DoubleRange impulse;
    private boolean impulseBidirectional;
    private double acceleration;
    private boolean accelerationBidirectional;
    private DoubleRange maxAcceleration;
    private DoubleRange max;
    private double braking;
    private DoubleRange turbulence;
    private double cursorImpulseInheritCoefficient;

    public static SpeedConfig getNewInstance() {
        return (SpeedConfig)CodecUtils.parseNewInstanceHacky(CODEC);
    }

    public double getImpulseBidirectional(RandomSource random) {
        return this.impulse.getRandom(random) * (double)(this.impulseBidirectional && random.nextBoolean() ? -1 : 1);
    }

    public double getAccelerationBidirectional(RandomSource random) {
        return this.acceleration * (double)(this.accelerationBidirectional && random.nextBoolean() ? -1 : 1);
    }

    @Generated
    public DoubleRange getImpulse() {
        return this.impulse;
    }

    @Generated
    public boolean isImpulseBidirectional() {
        return this.impulseBidirectional;
    }

    @Generated
    public double getAcceleration() {
        return this.acceleration;
    }

    @Generated
    public boolean isAccelerationBidirectional() {
        return this.accelerationBidirectional;
    }

    @Generated
    public DoubleRange getMaxAcceleration() {
        return this.maxAcceleration;
    }

    @Generated
    public DoubleRange getMax() {
        return this.max;
    }

    @Generated
    public double getBraking() {
        return this.braking;
    }

    @Generated
    public DoubleRange getTurbulence() {
        return this.turbulence;
    }

    @Generated
    public double getCursorImpulseInheritCoefficient() {
        return this.cursorImpulseInheritCoefficient;
    }

    @Generated
    public void setImpulse(DoubleRange impulse) {
        this.impulse = impulse;
    }

    @Generated
    public void setImpulseBidirectional(boolean impulseBidirectional) {
        this.impulseBidirectional = impulseBidirectional;
    }

    @Generated
    public void setAcceleration(double acceleration) {
        this.acceleration = acceleration;
    }

    @Generated
    public void setAccelerationBidirectional(boolean accelerationBidirectional) {
        this.accelerationBidirectional = accelerationBidirectional;
    }

    @Generated
    public void setMaxAcceleration(DoubleRange maxAcceleration) {
        this.maxAcceleration = maxAcceleration;
    }

    @Generated
    public void setMax(DoubleRange max) {
        this.max = max;
    }

    @Generated
    public void setBraking(double braking) {
        this.braking = braking;
    }

    @Generated
    public void setTurbulence(DoubleRange turbulence) {
        this.turbulence = turbulence;
    }

    @Generated
    public void setCursorImpulseInheritCoefficient(double cursorImpulseInheritCoefficient) {
        this.cursorImpulseInheritCoefficient = cursorImpulseInheritCoefficient;
    }

    @Generated
    public SpeedConfig(DoubleRange impulse, boolean impulseBidirectional, double acceleration, boolean accelerationBidirectional, DoubleRange maxAcceleration, DoubleRange max, double braking, DoubleRange turbulence, double cursorImpulseInheritCoefficient) {
        this.impulse = impulse;
        this.impulseBidirectional = impulseBidirectional;
        this.acceleration = acceleration;
        this.accelerationBidirectional = accelerationBidirectional;
        this.maxAcceleration = maxAcceleration;
        this.max = max;
        this.braking = braking;
        this.turbulence = turbulence;
        this.cursorImpulseInheritCoefficient = cursorImpulseInheritCoefficient;
    }
}

