/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.controller.speed;

import lombok.Generated;
import net.lopymine.ip.config.particle.ParticlePhysics;
import net.lopymine.ip.controller.speed.AbstractSpeedController;
import net.lopymine.ip.element.base.IMovableElement;
import net.lopymine.ip.element.base.IRotatableElement;
import net.minecraft.util.RandomSource;

public class RotationSpeedController<T extends IRotatableElement & IMovableElement>
extends AbstractSpeedController<RotationSpeedController<T>, T> {
    private boolean rotateInMovementDirection;
    private double rotation;

    public RotationSpeedController(ParticlePhysics.RotationSpeedPhysics.RotationConfig config, RandomSource random) {
        super(config.getSpeedConfig(), random, 0.0);
        this.rotateInMovementDirection = config.isRotateInMovementDirection();
    }

    @Override
    public void tick(T element) {
        super.tick(element);
        if (!this.rotateInMovementDirection) {
            return;
        }
        double deltaX = ((IMovableElement)element).getX() - ((IMovableElement)element).getLastX();
        double deltaY = ((IMovableElement)element).getY() - ((IMovableElement)element).getLastY();
        if (deltaX == 0.0 && deltaY == 0.0) {
            return;
        }
        double movementRotationRad = Math.atan2(-deltaY, -deltaX);
        double rotationDegrees = Math.toDegrees(movementRotationRad) - 90.0;
        this.rotation = rotationDegrees % 360.0;
    }

    @Generated
    public boolean isRotateInMovementDirection() {
        return this.rotateInMovementDirection;
    }

    @Generated
    public double getRotation() {
        return this.rotation;
    }

    @Generated
    public void setRotateInMovementDirection(boolean rotateInMovementDirection) {
        this.rotateInMovementDirection = rotateInMovementDirection;
    }

    @Generated
    public void setRotation(double rotation) {
        this.rotation = rotation;
    }
}

