/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.predicate.nbt;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import net.lopymine.ip.client.InventoryParticlesClient;
import net.lopymine.ip.config.InventoryParticlesConfig;
import net.lopymine.ip.extension.ItemExtension;
import net.lopymine.ip.predicate.IParticleSpawnPredicate;
import net.lopymine.ip.predicate.nbt.NbtNode;
import net.lopymine.ip.predicate.nbt.NbtNodeMatch;
import net.lopymine.ip.predicate.nbt.NbtNodeType;
import net.lopymine.ip.predicate.nbt.debug.DebugNbtPath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NbtParticleSpawnPredicate
implements IParticleSpawnPredicate {
    private String particleName;
    private HashSet<NbtNode> nodes;
    private NbtNodeMatch match;

    @Override
    public boolean test(ItemStack stack) {
        if (this.nodes.isEmpty()) {
            return true;
        }
        try {
            boolean bl;
            Minecraft client = Minecraft.getInstance();
            LocalPlayer player = client.player;
            if (player == null) {
                return false;
            }
            Tag nbt = (Tag)ItemStack.CODEC.encodeStart((DynamicOps)player.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)stack).getOrThrow();
            if (!(nbt instanceof CompoundTag)) {
                this.debugLog(null, DebugLogReason.ENCODED_WRONG_ROOT, ItemExtension.getStringName(stack.getItem()));
                return false;
            }
            CompoundTag root = (CompoundTag)nbt;
            int success = 0;
            ArrayList<DebugNbtPath> successPaths = new ArrayList<DebugNbtPath>();
            for (NbtNode node : this.nodes) {
                Tag element = root.get(node.getName());
                if (element == null) {
                    this.debugLog(null, DebugLogReason.NO_SUCH_ELEMENT_IN_ROOT, node.getName());
                    continue;
                }
                DebugNbtPath debugNbtPath = DebugNbtPath.create(node);
                ReadResult readResult = this.readElementByType(element, node, debugNbtPath);
                if (readResult != ReadResult.SUCCESS) continue;
                if (this.match == NbtNodeMatch.ANY) {
                    this.debugLog(debugNbtPath, DebugLogReason.MATCH, new Object[0]);
                    return true;
                }
                ++success;
                successPaths.add(debugNbtPath);
            }
            switch (this.match) {
                default: {
                    throw new MatchException(null, null);
                }
                case ANY: {
                    boolean bl2 = false;
                    break;
                }
                case ALL: {
                    boolean bl2;
                    if (success == this.nodes.size()) {
                        bl2 = true;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                case NONE: {
                    boolean bl2 = bl = success == 0;
                }
            }
            if (bl) {
                for (DebugNbtPath debugNbtPath : successPaths) {
                    this.debugLog(debugNbtPath, DebugLogReason.MATCH, new Object[0]);
                }
            }
            return bl;
        }
        catch (Exception e) {
            InventoryParticlesClient.LOGGER.error("Failed to read nbt from item \"{}\" for NbtParticleSpawnPredicate! Reason:", (Object)ItemExtension.getStringName(stack.getItem()), (Object)e);
            return true;
        }
    }

    private ReadResult readElementByType(Tag element, NbtNode node, @NotNull DebugNbtPath debugNbtPath) {
        boolean debugLog = InventoryParticlesConfig.getInstance().getMainConfig().isDebugModeEnabled();
        List checkValues = node.getCheckValue().orElse(new ArrayList());
        List nodes = node.getNext().orElse(new ArrayList());
        if (checkValues.isEmpty() && nodes.isEmpty()) {
            boolean rightType;
            switch (node.getType()) {
                default: {
                    throw new MatchException(null, null);
                }
                case OBJECT: {
                    boolean bl = element instanceof CompoundTag;
                    break;
                }
                case LIST: {
                    boolean bl = element instanceof CollectionTag;
                    break;
                }
                case STRING: {
                    boolean bl = element instanceof StringTag;
                    break;
                }
                case INT: {
                    boolean bl = rightType = element instanceof NumericTag;
                }
            }
            if (rightType) {
                return ReadResult.SUCCESS;
            }
            if (debugLog) {
                this.debugLog(debugNbtPath, DebugLogReason.TYPE_MISMATCH, node.getName(), element.getId(), node.getType().getId());
            }
            return ReadResult.FAILED;
        }
        boolean valueCheckedIfPresent = true;
        if (!checkValues.isEmpty()) {
            block6 : switch (node.getType()) {
                default: {
                    throw new MatchException(null, null);
                }
                case STRING: 
                case INT: {
                    boolean bl;
                    String value = null;
                    if (element instanceof StringTag) {
                        value = element.getAsString();
                    }
                    if (element instanceof NumericTag) {
                        NumericTag number = (NumericTag)element;
                        value = String.valueOf(number.getAsInt());
                    }
                    if (value == null) {
                        this.debugLog(debugNbtPath, DebugLogReason.NO_VALUE, node.getName());
                        bl = false;
                        break;
                    }
                    for (String findValue : checkValues) {
                        if (!findValue.equals(value)) continue;
                        bl = true;
                        break block6;
                    }
                    this.debugLog(debugNbtPath, DebugLogReason.WRONG_VALUE, node.getName(), value, new ArrayList(checkValues));
                    bl = false;
                    break;
                }
                case OBJECT: 
                case LIST: {
                    boolean bl;
                    if (node.getType() == NbtNodeType.LIST && checkValues.size() == 1) {
                        if (element instanceof CollectionTag) {
                            CollectionTag list = (CollectionTag)element;
                            List<String> values = List.of("EMPTY_LIST", "NOT_EMPTY_LIST");
                            boolean empty = ((String)checkValues.get(0)).equals(values.get(0));
                            boolean notEmpty = ((String)checkValues.get(0)).equals(values.get(1));
                            if (empty && list.isEmpty()) {
                                bl = true;
                                break;
                            }
                            if (empty) {
                                this.debugLog(debugNbtPath, DebugLogReason.CHECK_LIST_EMPTY, node.getName());
                                bl = false;
                                break;
                            }
                            if (notEmpty && !list.isEmpty()) {
                                bl = true;
                                break;
                            }
                            if (notEmpty) {
                                this.debugLog(debugNbtPath, DebugLogReason.CHECK_LIST_NOT_EMPTY, node.getName());
                                bl = false;
                                break;
                            }
                            this.debugLog(debugNbtPath, DebugLogReason.CHECK_LIST_UNKNOWN, node.getName(), checkValues.get(0), values);
                            bl = false;
                            break;
                        }
                        this.debugLog(debugNbtPath, DebugLogReason.CHECK_VALUE_IN_NOT_LIST_OBJECT, new Object[]{node.getName(), node.getType(), NbtNodeType.LIST});
                        bl = false;
                        break;
                    }
                    this.debugLog(debugNbtPath, DebugLogReason.NOT_STRING_LIKE, new Object[]{node.getName(), node.getType(), NbtNodeType.STRING_LIKE});
                    bl = valueCheckedIfPresent = true;
                }
            }
            if (nodes.isEmpty()) {
                return valueCheckedIfPresent ? ReadResult.SUCCESS : ReadResult.FAILED;
            }
        }
        Stream<ReadResult> stream = nodes.stream().map(nextNode -> {
            debugNbtPath.next((NbtNode)nextNode);
            switch (node.getType()) {
                case OBJECT: {
                    if (element instanceof CompoundTag) {
                        CompoundTag nbt = (CompoundTag)element;
                        Tag nextElement = nbt.get(nextNode.getName());
                        if (nextElement == null) {
                            Set set = nbt.getAllKeys();
                            this.debugLog(debugNbtPath, DebugLogReason.NODE_NOT_FOUND, nextNode.getName(), set);
                            return ReadResult.FAILED;
                        }
                        return this.readElementByType(nextElement, (NbtNode)nextNode, debugNbtPath);
                    }
                    this.debugLog(debugNbtPath, DebugLogReason.OBJECT_LIKE_TYPE_MISMATCH, new Object[]{node.getName(), node.getType(), NbtNodeType.OBJECT});
                    return ReadResult.FAILED;
                }
                case LIST: {
                    if (element instanceof CollectionTag) {
                        CollectionTag list = (CollectionTag)element;
                        for (Tag nbtElement : list) {
                            if (this.readElementByType(nbtElement, (NbtNode)nextNode, debugNbtPath) != ReadResult.SUCCESS) continue;
                            return ReadResult.SUCCESS;
                        }
                        this.debugLog(debugNbtPath, DebugLogReason.NODE_NOT_FOUND_IN_LIST, nextNode.getName());
                        return ReadResult.FAILED;
                    }
                    this.debugLog(debugNbtPath, DebugLogReason.OBJECT_LIKE_TYPE_MISMATCH, new Object[]{node.getName(), node.getType(), NbtNodeType.LIST});
                    return ReadResult.FAILED;
                }
            }
            this.debugLog(debugNbtPath, DebugLogReason.NOT_OBJECT_LIKE, new Object[]{node.getName(), node.getType(), NbtNodeType.OBJECT_LIKE});
            return ReadResult.FAILED;
        });
        boolean bl = switch (node.getNextMatchType()) {
            default -> throw new MatchException(null, null);
            case NbtNodeMatch.NONE -> stream.noneMatch(result -> result == ReadResult.SUCCESS);
            case NbtNodeMatch.ALL -> stream.allMatch(result -> result == ReadResult.SUCCESS);
            case NbtNodeMatch.ANY -> stream.anyMatch(result -> result == ReadResult.SUCCESS);
        };
        return bl && valueCheckedIfPresent ? ReadResult.SUCCESS : ReadResult.FAILED;
    }

    private void debugLog(@Nullable DebugNbtPath debugNbtPath, DebugLogReason reason, Object ... objects) {
        if (!InventoryParticlesConfig.getInstance().getMainConfig().isNbtDebugModeEnabled()) {
            return;
        }
        reason.debug(this.particleName, debugNbtPath, objects);
    }

    @Generated
    public String getParticleName() {
        return this.particleName;
    }

    @Generated
    public HashSet<NbtNode> getNodes() {
        return this.nodes;
    }

    @Generated
    public NbtNodeMatch getMatch() {
        return this.match;
    }

    @Generated
    public void setParticleName(String particleName) {
        this.particleName = particleName;
    }

    @Generated
    public void setNodes(HashSet<NbtNode> nodes) {
        this.nodes = nodes;
    }

    @Generated
    public void setMatch(NbtNodeMatch match) {
        this.match = match;
    }

    @Generated
    public NbtParticleSpawnPredicate(String particleName, HashSet<NbtNode> nodes, NbtNodeMatch match) {
        this.particleName = particleName;
        this.nodes = nodes;
        this.match = match;
    }

    private static enum DebugLogReason {
        MATCH("Successful NBT Predicate match."),
        ENCODED_WRONG_ROOT("Encoded invalid root NBT for item \"{}\"."),
        NO_SUCH_ELEMENT_IN_ROOT("Missing NBT element \"{}\" in root NBT."),
        TYPE_MISMATCH("NBT node \"{}\" has wrong type. Found type: \"{}\", Expected type: \"{}\"."),
        NO_VALUE("NBT node \"{}\" has no string-like value."),
        WRONG_VALUE("NBT node \"{}\" has unexpected value. Found: \"{}\", Expected one of: \"{}\"."),
        OBJECT_LIKE_TYPE_MISMATCH("Cannot get any next NBT node from object-like NBT node because of type mismatch. Node: \"{}\", Found type: \"{}\", Expected type: \"{}\"."),
        NOT_STRING_LIKE("NBT node \"{}\" is not string-like. Found type: \"{}\", Expected one of: \"{}\"."),
        NOT_OBJECT_LIKE("NBT node \"{}\" is not object-like. Found type: \"{}\", Expected one of: \"{}\"."),
        NODE_NOT_FOUND("Next NBT node \"{}\" not found. Available nodes: \"{}\"."),
        NODE_NOT_FOUND_IN_LIST("Next NBT node \"{}\" not found in the NBT list node."),
        CHECK_LIST_UNKNOWN("Unknown check mode for NBT list \"{}\". Found mode: \"{}\", Expected one of: \"{}\"."),
        CHECK_LIST_EMPTY("Required empty NBT list, but \"{}\" wasn't."),
        CHECK_LIST_NOT_EMPTY("Required NBT list with any element, but \"{}\" was empty."),
        CHECK_VALUE_IN_NOT_LIST_OBJECT("NBT node \"{}\" is not list-like. Found type: \"{}\", Expected one of: \"{}\".");

        private final String message;

        private DebugLogReason(String message) {
            this.message = message;
        }

        public void debug(String particleName, @Nullable DebugNbtPath path, Object ... objects) {
            String string = this.message + (path == null ? "" : " Path: %s".formatted(path.toString()));
            if (path != null) {
                path.back();
            }
            if (this == MATCH) {
                InventoryParticlesClient.LOGGER.info("[%s] %s".formatted(particleName, string), objects);
            } else {
                InventoryParticlesClient.LOGGER.error("[%s] %s".formatted(particleName, string), objects);
            }
        }
    }

    private static enum ReadResult {
        FAILED,
        SUCCESS;

    }
}

