/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.spawner;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import net.lopymine.ip.color.IParticleColorType;
import net.lopymine.ip.config.InventoryParticlesConfig;
import net.lopymine.ip.config.particle.ParticleHolder;
import net.lopymine.ip.config.range.IntegerRange;
import net.lopymine.ip.controller.color.ColorController;
import net.lopymine.ip.element.InventoryCursor;
import net.lopymine.ip.element.InventoryParticle;
import net.lopymine.ip.element.base.TickElement;
import net.lopymine.ip.predicate.IParticleSpawnPredicate;
import net.lopymine.ip.spawner.IParticleSpawnPos;
import net.lopymine.ip.spawner.IParticleSpawner;
import net.lopymine.ip.spawner.ParticleSpawnArea;
import net.lopymine.ip.spawner.context.ParticleSpawnContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ParticleSpawner
extends TickElement
implements IParticleSpawner {
    private final RandomSource random = RandomSource.create();
    @Nullable
    private ParticleSpawnArea spawnArea;
    private IntegerRange countRange;
    private IntegerRange frequencyRange;
    private double speedCoefficient;
    private IParticleColorType colorType;
    private IParticleSpawnPredicate spawnCondition;
    private Function<ParticleSpawnContext, InventoryParticle> function;
    private int nextSpawnTicks = 0;

    public ParticleSpawner(ResourceLocation spawnArea, IntegerRange countRange, IntegerRange frequencyRange, double speedCoefficient, IParticleColorType colorType, IParticleSpawnPredicate spawnCondition, Function<ParticleSpawnContext, InventoryParticle> function) {
        this.spawnArea = ParticleSpawnArea.readFromTexture(spawnArea);
        this.countRange = countRange;
        this.frequencyRange = frequencyRange;
        this.speedCoefficient = speedCoefficient;
        this.colorType = colorType;
        this.spawnCondition = spawnCondition;
        this.function = function;
    }

    @Override
    public List<InventoryParticle> spawnFromCursor(InventoryCursor cursor) {
        int spawnCount = (int)((double)this.random.nextIntBetweenInclusive(this.countRange.getMin(), this.countRange.getMax()) * this.speedCoefficient * (Math.sqrt(cursor.getSpeed()) * 1.0));
        return this.createParticles(spawnCount, cursor, (InventoryParticle particle) -> this.spawnParticleAtCursorDeltaPath((InventoryParticle)particle, cursor));
    }

    private void spawnParticleAtCursorDeltaPath(InventoryParticle particle, InventoryCursor cursor) {
        RandomSource random = particle.getRandom();
        int deltaX = cursor.getX() - cursor.getLastX();
        int deltaY = cursor.getY() - cursor.getLastY();
        float progress = (float)random.nextIntBetweenInclusive(0, 100) / 100.0f;
        int pathX = (int)((float)deltaX * progress);
        int pathY = (int)((float)deltaY * progress);
        particle.setX(particle.getX() - (double)pathX + (double)random.nextIntBetweenInclusive(0, 2));
        particle.setY(particle.getY() - (double)pathY + (double)random.nextIntBetweenInclusive(0, 2));
    }

    @Override
    public List<InventoryParticle> tickAndSpawn(ParticleSpawnContext context) {
        this.tick();
        if (this.nextSpawnTicks == 0) {
            int ticks = this.random.nextIntBetweenInclusive(this.frequencyRange.getMin(), this.frequencyRange.getMax());
            int ticksToWaitForNextSpawn = (int)((double)ticks * context.getCooldownCoefficient() * InventoryParticlesConfig.getInstance().getCoefficientsConfig().getGlobalConfig().getCooldownCoefficient());
            this.nextSpawnTicks = this.ticks + ticksToWaitForNextSpawn;
        }
        if (this.ticks < this.nextSpawnTicks) {
            return List.of();
        }
        this.nextSpawnTicks = 0;
        return this.spawn(context);
    }

    @Override
    public List<InventoryParticle> spawn(ParticleSpawnContext context) {
        return this.createParticles(this.random.nextIntBetweenInclusive(this.countRange.getMin(), this.countRange.getMax()), context, (InventoryParticle particle) -> {});
    }

    private List<InventoryParticle> createParticles(int spawnCount, InventoryCursor cursor, Consumer<InventoryParticle> consumer) {
        return this.createParticles(spawnCount, ParticleSpawnContext.cursor(cursor), consumer);
    }

    private List<InventoryParticle> createParticles(int spawnCount, ParticleSpawnContext context, Consumer<InventoryParticle> consumer) {
        if (spawnCount == 0) {
            if (context == ParticleSpawnContext.GUI_ACTION_SLOT) {
                spawnCount = 1;
            } else {
                return List.of();
            }
        }
        if (!this.spawnCondition.test(context.getStack())) {
            return List.of();
        }
        float count = (float)((double)spawnCount * context.getCountCoefficient() * InventoryParticlesConfig.getInstance().getCoefficientsConfig().getGlobalConfig().getCountCoefficient());
        int countOfParticles = count > 0.0f && count < 1.0f ? 1 : (int)count;
        ArrayList<InventoryParticle> particles = new ArrayList<InventoryParticle>();
        for (int i = 0; i < countOfParticles; ++i) {
            InventoryParticle particle = this.function.apply(context);
            consumer.accept(particle);
            this.offsetParticlePos(particle);
            this.setParticleColorController(particle, context);
            particles.add(particle);
        }
        return particles;
    }

    private void setParticleColorController(InventoryParticle particle, ParticleSpawnContext context) {
        ItemStack currentItem = context.getStack();
        IParticleColorType type = this.colorType.copy();
        type.compile(currentItem, particle.getRandom());
        particle.setColorController(new ColorController<InventoryParticle>(type));
    }

    private void offsetParticlePos(InventoryParticle particle) {
        IParticleSpawnPos particleSpawnPos = this.spawnArea == null ? null : this.spawnArea.getRandomPos(particle.getRandom());
        particle.setX(particle.getX() - 8.0);
        particle.setY(particle.getY() - 8.0);
        if (particleSpawnPos != null) {
            particle.setX(particle.getX() - (double)particleSpawnPos.getXOffset() + (double)particleSpawnPos.x() - particle.getWidth() / 2.0);
            particle.setY(particle.getY() - (double)particleSpawnPos.getYOffset() + (double)particleSpawnPos.y() - particle.getHeight() / 2.0);
        }
        particle.setLastX(particle.getX());
        particle.setLastY(particle.getY());
    }

    @Override
    public void bump(ParticleHolder holder) {
        this.spawnArea = ParticleSpawnArea.readFromTexture(holder.getSpawnArea());
        this.countRange = holder.getSpawnCount();
        this.frequencyRange = holder.getSpawnFrequency();
        this.speedCoefficient = holder.getSpeedCoefficient();
        this.colorType = holder.getColor();
        this.spawnCondition = holder.getSpawnCondition();
        this.nextSpawnTicks = 0;
    }

    @Generated
    public RandomSource getRandom() {
        return this.random;
    }

    @Nullable
    @Generated
    public ParticleSpawnArea getSpawnArea() {
        return this.spawnArea;
    }

    @Generated
    public IntegerRange getCountRange() {
        return this.countRange;
    }

    @Generated
    public IntegerRange getFrequencyRange() {
        return this.frequencyRange;
    }

    @Generated
    public double getSpeedCoefficient() {
        return this.speedCoefficient;
    }

    @Generated
    public IParticleColorType getColorType() {
        return this.colorType;
    }

    @Generated
    public IParticleSpawnPredicate getSpawnCondition() {
        return this.spawnCondition;
    }

    @Generated
    public Function<ParticleSpawnContext, InventoryParticle> getFunction() {
        return this.function;
    }

    @Generated
    public int getNextSpawnTicks() {
        return this.nextSpawnTicks;
    }

    @Generated
    public void setSpawnArea(@Nullable ParticleSpawnArea spawnArea) {
        this.spawnArea = spawnArea;
    }

    @Generated
    public void setCountRange(IntegerRange countRange) {
        this.countRange = countRange;
    }

    @Generated
    public void setFrequencyRange(IntegerRange frequencyRange) {
        this.frequencyRange = frequencyRange;
    }

    @Generated
    public void setSpeedCoefficient(double speedCoefficient) {
        this.speedCoefficient = speedCoefficient;
    }

    @Generated
    public void setColorType(IParticleColorType colorType) {
        this.colorType = colorType;
    }

    @Generated
    public void setSpawnCondition(IParticleSpawnPredicate spawnCondition) {
        this.spawnCondition = spawnCondition;
    }

    @Generated
    public void setFunction(Function<ParticleSpawnContext, InventoryParticle> function) {
        this.function = function;
    }

    @Generated
    public void setNextSpawnTicks(int nextSpawnTicks) {
        this.nextSpawnTicks = nextSpawnTicks;
    }

    @Generated
    public ParticleSpawner(@Nullable ParticleSpawnArea spawnArea, IntegerRange countRange, IntegerRange frequencyRange, double speedCoefficient, IParticleColorType colorType, IParticleSpawnPredicate spawnCondition, Function<ParticleSpawnContext, InventoryParticle> function, int nextSpawnTicks) {
        this.spawnArea = spawnArea;
        this.countRange = countRange;
        this.frequencyRange = frequencyRange;
        this.speedCoefficient = speedCoefficient;
        this.colorType = colorType;
        this.spawnCondition = spawnCondition;
        this.function = function;
        this.nextSpawnTicks = nextSpawnTicks;
    }
}

