/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mossylib.client.command;

import java.util.UUID;
import net.lopymine.mossylib.MossyLib;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EntityType;

public class CommandTextBuilder {
    private final String key;
    private final MutableComponent text;

    private CommandTextBuilder(String key, Object ... args) {
        this.key = key;
        this.text = CommandTextBuilder.translatable(key, args);
    }

    private static MutableComponent translatable(String key, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (CommandTextBuilder.isPrimitive(object) || object instanceof Component) continue;
            args[i] = String.valueOf(object);
        }
        return Component.literal((String)MossyLib.text(key, args).getString().replace("&", "\u00a7"));
    }

    private static boolean isPrimitive(Object object) {
        return object instanceof Number || object instanceof Boolean || object instanceof String;
    }

    public static CommandTextBuilder startBuilder(String key, Object ... args) {
        return new CommandTextBuilder("command." + key, args);
    }

    public CommandTextBuilder withShowEntity(EntityType<?> type, UUID uuid, String name) {
        return this.withShowEntity(type, uuid, (Component)Component.literal((String)name));
    }

    public CommandTextBuilder withShowEntity(EntityType<?> type, UUID uuid, Component name) {
        HoverEvent hoverEvent = CommandTextBuilder.getHoverEvent(HoverEvent.Action.SHOW_ENTITY, new HoverEvent.EntityTooltipInfo(type, uuid, name));
        return this.withHoverEvent(hoverEvent);
    }

    public CommandTextBuilder withHoverText(Object ... args) {
        MutableComponent hoverText = CommandTextBuilder.translatable(this.key + ".hover_text", args);
        HoverEvent hoverEvent = CommandTextBuilder.getHoverEvent(HoverEvent.Action.SHOW_TEXT, hoverText);
        return this.withHoverEvent(hoverEvent);
    }

    public CommandTextBuilder withHoverEvent(HoverEvent hoverEvent) {
        Style style = this.text.getStyle().withHoverEvent(hoverEvent);
        this.text.setStyle(style);
        return this;
    }

    public CommandTextBuilder withCopyToClipboard(Object value) {
        ClickEvent clickEvent = CommandTextBuilder.getClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, value);
        return this.withClickEvent(clickEvent);
    }

    public CommandTextBuilder withClickEvent(ClickEvent clickEvent) {
        Style style = this.text.getStyle().withClickEvent(clickEvent);
        this.text.setStyle(style);
        return this;
    }

    public static <T> HoverEvent getHoverEvent(HoverEvent.Action<T> action, T value) {
        return new HoverEvent(action, value);
    }

    public static ClickEvent getClickEvent(ClickEvent.Action action, Object value) {
        return new ClickEvent(action, (String)value);
    }

    public Component build() {
        return this.text;
    }
}

