/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mossylib.modmenu;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.lopymine.mossylib.client.MossyLibClient;
import net.lopymine.mossylib.modmenu.NoConfigLibraryScreen;
import net.minecraft.class_437;

public abstract class AbstractModMenuIntegration
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        if (fabricLoader.isModLoaded("yet_another_config_lib_v3")) {
            ModContainer modContainer = (ModContainer)fabricLoader.getModContainer("yet_another_config_lib_v3").orElseThrow();
            Version version = modContainer.getMetadata().getVersion();
            try {
                Version requestsVersion = Version.parse((String)"3.6.6+1.20.1-fabric");
                if (version.compareTo((Object)requestsVersion) >= 0) {
                    return this::createConfigScreen;
                }
            }
            catch (VersionParsingException e) {
                MossyLibClient.LOGGER.error("Failed to compare YACL version, tell mod author about this error: ", new Object[]{e});
            }
            return parent -> NoConfigLibraryScreen.createScreenAboutOldVersion(parent, version.getFriendlyString(), this.getModId());
        }
        return parent -> NoConfigLibraryScreen.createScreen(parent, this.getModId());
    }

    protected abstract String getModId();

    protected abstract class_437 createConfigScreen(class_437 var1);
}

