/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.renderer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.lopymine.ip.client.InventoryParticlesClient;
import net.lopymine.ip.config.InventoryParticlesConfig;
import net.lopymine.ip.config.optimization.ParticleDeletionMode;
import net.lopymine.ip.config.sub.InventoryParticleConfig;
import net.lopymine.ip.element.InventoryCursor;
import net.lopymine.ip.element.InventoryParticle;
import net.lopymine.ip.element.base.TickElement;
import net.lopymine.ip.renderer.IParticle;
import net.lopymine.ip.resourcepack.ResourcePackParticleConfigsManager;
import net.lopymine.ip.spawner.IParticleSpawner;
import net.lopymine.ip.spawner.context.ParticleSpawnContext;
import net.lopymine.ip.utils.ParticleDrawUtils;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryParticlesRenderer
extends TickElement {
    private static final InventoryParticlesRenderer INSTANCE = new InventoryParticlesRenderer();
    private final Collection<IParticle> screenParticles = InventoryParticlesRenderer.getScreenParticlesList();
    private final List<IParticle> pendingParticles = new ArrayList<IParticle>();
    private final class_5819 random = class_5819.method_43047();
    private InventoryCursor cursor = new InventoryCursor();
    private boolean stoppedByInitializationReason;
    private boolean stoppedTicking;
    private int ticksPerTick = 1;
    private int nextTick = 1;
    @Nullable
    private IParticle hoveredParticle;
    @Nullable
    private IParticle selectedParticle;

    private InventoryParticlesRenderer() {
    }

    public static InventoryParticlesRenderer getInstance() {
        return INSTANCE;
    }

    public void render(class_332 context, float tickProgress) {
        this.hoveredParticle = null;
        if (this.screenParticles.isEmpty()) {
            return;
        }
        this.runSoft(() -> {
            ParticleDrawUtils.prepareParticlesBuffer();
            for (IParticle particle : this.screenParticles) {
                if (particle == null) continue;
                particle.render(context, this.cursor, tickProgress, this.isStoppedTicking());
                if (!particle.isHovered()) continue;
                this.hoveredParticle = particle;
            }
            ParticleDrawUtils.endParticlesBuffer();
        }, "rendering_particle");
    }

    public void updateCursor(int mouseY, int mouseX, class_1799 item, @Nullable class_1735 focusedSlot) {
        this.cursor.setMouseY(mouseY);
        this.cursor.setMouseX(mouseX);
        this.cursor.setCurrentStack(item);
        this.cursor.setHoveredSlot(focusedSlot);
    }

    public void tick(@Nullable class_1703 handler, @Nullable Integer inventoryX, @Nullable Integer inventoryY) {
        if (this.stoppedTicking || this.stoppedByInitializationReason) {
            return;
        }
        super.tick();
        if (this.ticks < this.nextTick) {
            return;
        }
        this.nextTick = this.ticks + this.ticksPerTick;
        this.runSoft(() -> {
            this.cursor.tick();
            InventoryParticleConfig config = InventoryParticlesConfig.getInstance().getParticleConfig();
            if (config.isGuiSlotsSpawnEnabled() && inventoryX != null && inventoryY != null && handler != null) {
                this.spawnAllSlotsParticles(handler, inventoryX, inventoryY);
            }
            if (config.isHoveredSlotSpawnEnabled() && inventoryX != null && inventoryY != null) {
                this.spawnHoveredSlotParticles(inventoryX, inventoryY);
            }
            if (config.isCursorSpawnEnabled()) {
                this.spawnCursorParticles();
            }
            this.pushPendingParticles();
            this.screenParticles.removeIf(particle -> {
                if (particle == null) {
                    return true;
                }
                particle.tick();
                return particle.isDead() && !particle.isSelected();
            });
        }, "ticking_inventory_particles");
    }

    private void pushPendingParticles() {
        this.screenParticles.addAll(this.pendingParticles);
        this.pendingParticles.clear();
    }

    private void spawnHoveredSlotParticles(int inventoryX, int inventoryY) {
        class_1735 hoveredSlot = this.cursor.getHoveredSlot();
        if (hoveredSlot == null) {
            return;
        }
        class_1799 stack = hoveredSlot.method_7677();
        if (stack.method_7960()) {
            return;
        }
        class_1792 item = stack.method_7909();
        List<IParticleSpawner> spawners = ResourcePackParticleConfigsManager.getPerItemParticleSpawners().get(item);
        if (spawners == null) {
            return;
        }
        ParticleSpawnContext context = ParticleSpawnContext.hoveredSlot(hoveredSlot, inventoryX, inventoryY);
        for (IParticleSpawner spawner : spawners) {
            for (InventoryParticle particle : spawner.tickAndSpawn(context)) {
                this.spawnParticle(particle);
            }
        }
    }

    private void spawnAllSlotsParticles(class_1703 handler, int inventoryX, int inventoryY) {
        for (class_1735 slot : handler.field_7761) {
            List<IParticleSpawner> particleSpawners;
            class_1799 stack;
            if (this.cursor.getHoveredSlot() != null && this.cursor.getHoveredSlot().field_7874 == slot.field_7874 || (stack = slot.method_7677()).method_7960() || (particleSpawners = ResourcePackParticleConfigsManager.getPerItemParticleSpawners().get(stack.method_7909())) == null) continue;
            ParticleSpawnContext context = ParticleSpawnContext.slots(slot, inventoryX, inventoryY);
            for (IParticleSpawner spawner : particleSpawners) {
                for (InventoryParticle particle : spawner.tickAndSpawn(context)) {
                    this.spawnParticle(particle);
                }
            }
        }
    }

    private void spawnCursorParticles() {
        class_1799 stack = this.cursor.getCurrentStack();
        if (stack.method_7960()) {
            return;
        }
        List<IParticleSpawner> particleSpawners = ResourcePackParticleConfigsManager.getPerItemParticleSpawners().get(stack.method_7909());
        if (particleSpawners != null) {
            ArrayList<InventoryParticle> particles = new ArrayList<InventoryParticle>();
            for (IParticleSpawner spawner : particleSpawners) {
                particles.addAll(spawner.tickAndSpawn(ParticleSpawnContext.cursor(this.cursor)));
                particles.addAll(spawner.spawnFromCursor(this.cursor));
            }
            particles.forEach(this::spawnParticle);
        }
    }

    public void spawnParticle(IParticle particle) {
        InventoryParticlesConfig config = InventoryParticlesConfig.getInstance();
        int difference = this.screenParticles.size() + 1 - config.getParticleConfig().getMaxParticles();
        if (difference > 0) {
            this.clearParticlesForNewOnes(difference, config.getParticleConfig().getParticleDeletionMode());
        }
        this.pendingParticles.add(particle);
    }

    private void clearParticlesForNewOnes(int difference, ParticleDeletionMode mode) {
        switch (mode) {
            case OLDEST: {
                Collection<IParticle> collection = this.screenParticles;
                if (!(collection instanceof ArrayDeque)) {
                    return;
                }
                ArrayDeque deque = (ArrayDeque)collection;
                for (int i = 0; i < difference; ++i) {
                    deque.pollFirst();
                }
                break;
            }
            case RANDOM: {
                Collection<IParticle> i = this.screenParticles;
                if (!(i instanceof ArrayList)) {
                    return;
                }
                ArrayList list = (ArrayList)i;
                for (int i2 = 0; i2 < difference; ++i2) {
                    list.remove(this.random.method_39332(0, list.size() - 1));
                }
                break;
            }
        }
    }

    public void clear() {
        this.screenParticles.clear();
        this.pendingParticles.clear();
        this.hoveredParticle = null;
        this.selectedParticle = null;
        this.stoppedByInitializationReason = true;
    }

    public void init() {
        this.cursor = new InventoryCursor();
        this.stoppedByInitializationReason = false;
    }

    public void mouseClicked(int button) {
        if (button != 1) {
            return;
        }
        if (!this.isStoppedTicking()) {
            return;
        }
        if (this.selectedParticle != null) {
            this.selectedParticle.setSelected(false);
            this.selectedParticle = null;
            this.playClickSound();
            return;
        }
        if (this.hoveredParticle == null) {
            return;
        }
        this.hoveredParticle.setSelected(true);
        this.selectedParticle = this.hoveredParticle;
        this.playClickSound();
    }

    private void playClickSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public void updateParticlesPositions(double xCoefficient, double yCoefficient) {
        for (IParticle particle : this.screenParticles) {
            particle.setX(particle.getX() * xCoefficient);
            particle.setY(particle.getY() * yCoefficient);
        }
        for (IParticle particle : this.pendingParticles) {
            particle.setX(particle.getX() * xCoefficient);
            particle.setY(particle.getY() * yCoefficient);
        }
    }

    private void runSoft(Runnable runnable, String action) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                class_5250 text = class_2561.method_43470((String)"[%s] ".formatted("Inventory Particles")).method_10852((class_2561)class_2561.method_43470((String)"Unexpected error with id \"%s\", please report this issue with your game logs! Mod was automatically disabled to prevent spamming ^^".formatted(action)).method_27692(class_124.field_1061));
                player.method_7353((class_2561)text, false);
            }
            InventoryParticlesClient.LOGGER.error("[{}] Failed to process inventory particles!", (Object)action, (Object)e);
            InventoryParticlesConfig config = InventoryParticlesConfig.getInstance();
            config.getMainConfig().setModEnabled(false);
            config.saveAsync();
        }
    }

    public void onGuiAction(class_1735 slot, class_1799 stack, int inventoryX, int inventoryY) {
        if (stack.method_7960() && !slot.method_7681()) {
            return;
        }
        int chanceOfSpawn = 100 - (int)Math.ceil(InventoryParticlesConfig.getInstance().getCoefficientsConfig().getGuiActionConfig().getCooldownCoefficient());
        int r = this.random.method_39332(0, 100);
        if (r < chanceOfSpawn) {
            return;
        }
        this.runSoft(() -> {
            List<IParticleSpawner> spawners = ResourcePackParticleConfigsManager.getPerItemParticleSpawners().get(stack.method_7960() ? slot.method_7677().method_7909() : stack.method_7909());
            if (spawners != null) {
                ParticleSpawnContext context = ParticleSpawnContext.guiActionSlot(slot, inventoryX, inventoryY);
                if (context.getStack().method_7960()) {
                    context.setStack(stack);
                }
                for (IParticleSpawner spawner : spawners) {
                    for (InventoryParticle particle : spawner.spawn(context)) {
                        this.spawnParticle(particle);
                    }
                }
            }
        }, "put_in_slot");
    }

    @NotNull
    private static Collection<IParticle> getScreenParticlesList() {
        return switch (InventoryParticlesConfig.getInstance().getParticleConfig().getParticleDeletionMode()) {
            default -> throw new IncompatibleClassChangeError();
            case ParticleDeletionMode.OLDEST -> new ArrayDeque();
            case ParticleDeletionMode.RANDOM -> new ArrayList();
        };
    }

    @Generated
    public List<IParticle> getPendingParticles() {
        return this.pendingParticles;
    }

    @Generated
    public class_5819 getRandom() {
        return this.random;
    }

    @Generated
    public InventoryCursor getCursor() {
        return this.cursor;
    }

    @Generated
    public boolean isStoppedByInitializationReason() {
        return this.stoppedByInitializationReason;
    }

    @Generated
    public boolean isStoppedTicking() {
        return this.stoppedTicking;
    }

    @Generated
    public int getTicksPerTick() {
        return this.ticksPerTick;
    }

    @Generated
    public int getNextTick() {
        return this.nextTick;
    }

    @Nullable
    @Generated
    public IParticle getHoveredParticle() {
        return this.hoveredParticle;
    }

    @Nullable
    @Generated
    public IParticle getSelectedParticle() {
        return this.selectedParticle;
    }

    @Generated
    public void setCursor(InventoryCursor cursor) {
        this.cursor = cursor;
    }

    @Generated
    public void setStoppedByInitializationReason(boolean stoppedByInitializationReason) {
        this.stoppedByInitializationReason = stoppedByInitializationReason;
    }

    @Generated
    public void setStoppedTicking(boolean stoppedTicking) {
        this.stoppedTicking = stoppedTicking;
    }

    @Generated
    public void setTicksPerTick(int ticksPerTick) {
        this.ticksPerTick = ticksPerTick;
    }

    @Generated
    public void setNextTick(int nextTick) {
        this.nextTick = nextTick;
    }

    @Generated
    public void setHoveredParticle(@Nullable IParticle hoveredParticle) {
        this.hoveredParticle = hoveredParticle;
    }

    @Generated
    public void setSelectedParticle(@Nullable IParticle selectedParticle) {
        this.selectedParticle = selectedParticle;
    }

    @Generated
    public Collection<IParticle> getScreenParticles() {
        return this.screenParticles;
    }
}

