/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.resourcepack;

import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.lopymine.ip.atlas.InventoryParticlesAtlasManager;
import net.lopymine.ip.client.InventoryParticlesClient;
import net.lopymine.ip.config.particle.ParticleConfig;
import net.lopymine.ip.config.particle.ParticleHolder;
import net.lopymine.ip.spawner.IParticleSpawner;
import net.lopymine.ip.spawner.ParticleSpawner;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.slf4j.Logger;

public class ResourcePackParticleConfigsManager {
    private static final Map<ParticleHolder, RegisteredConfig> REGISTERED_CONFIGS = new HashMap<ParticleHolder, RegisteredConfig>();
    private static final Map<class_1792, List<IParticleSpawner>> PER_ITEM_PARTICLE_SPAWNERS = new HashMap<class_1792, List<IParticleSpawner>>();

    public static void reload() {
        PER_ITEM_PARTICLE_SPAWNERS.clear();
        InventoryParticlesClient.LOGGER.info("Started registering particle configs from resources...");
        class_3300 resourceManager = class_310.method_1551().method_1478();
        AtomicInteger foundConfigs = new AtomicInteger();
        AtomicInteger registeredConfigs = new AtomicInteger();
        resourceManager.method_14488(InventoryParticlesAtlasManager.FOLDER_ID.method_12832(), id -> id.method_12832().endsWith(".json5") || id.method_12832().endsWith("json")).forEach((id, resource) -> {
            foundConfigs.getAndIncrement();
            try (InputStream inputStream = resource.method_14482();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                ParticleConfig config = (ParticleConfig)((Pair)ParticleConfig.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow(false, arg_0 -> ((Logger)InventoryParticlesClient.LOGGER).error(arg_0))).getFirst();
                for (ParticleHolder holder : config.getHolders()) {
                    class_1792 item = holder.getItem().getItem();
                    ParticleSpawner spawner = holder.create(config::createParticle);
                    ResourcePackParticleConfigsManager.registerItemSpawner(id, item, holder, spawner);
                }
                InventoryParticlesClient.LOGGER.debug("Registered config at \"{}\"", id);
                registeredConfigs.getAndIncrement();
            }
            catch (Exception e) {
                InventoryParticlesClient.LOGGER.error("Failed to parse particle config from \"{}\"! Reason:", id, (Object)e);
            }
        });
        InventoryParticlesClient.LOGGER.info("Registering finished, found: {}, registered: {}", (Object)foundConfigs.get(), (Object)registeredConfigs.get());
    }

    public static void registerItemSpawner(class_2960 location, class_1792 item, ParticleHolder holder, IParticleSpawner spawner) {
        PER_ITEM_PARTICLE_SPAWNERS.computeIfAbsent(item, i -> new ArrayList()).add(spawner);
        REGISTERED_CONFIGS.put(holder, new RegisteredConfig(location, spawner));
    }

    public static Map<ParticleHolder, RegisteredConfig> getRegisteredConfigs() {
        return REGISTERED_CONFIGS;
    }

    public static Map<class_1792, List<IParticleSpawner>> getPerItemParticleSpawners() {
        return PER_ITEM_PARTICLE_SPAWNERS;
    }

    public record RegisteredConfig(class_2960 id, IParticleSpawner spawner) {
    }
}

