/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder;

import com.mojang.logging.LogUtils;
import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.potionstudios.wayfinder.advancements.critereon.WayfinderCriteriaTriggers;
import net.potionstudios.wayfinder.advancements.critereon.WayfinderEntitySubPredicates;
import net.potionstudios.wayfinder.config.Config;
import net.potionstudios.wayfinder.config.ConfigUtils;
import net.potionstudios.wayfinder.sounds.WayfinderSounds;
import net.potionstudios.wayfinder.tags.WayfinderEntityTypeTags;
import net.potionstudios.wayfinder.world.entity.WayfinderEntityType;
import net.potionstudios.wayfinder.world.entity.ai.memory.WayfinderMemoryModuleType;
import net.potionstudios.wayfinder.world.entity.ai.sensing.WayfinderSensorType;
import net.potionstudios.wayfinder.world.entity.block.WayfinderBlockEntityType;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;
import net.potionstudios.wayfinder.world.item.WayfinderItems;
import net.potionstudios.wayfinder.world.level.block.WayfinderBlocks;
import org.slf4j.Logger;

public class Wayfinder {
    public static final String MOD_ID = "wayfinder";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static Config CONFIG = ConfigUtils.loadConfig(Config.class);

    public static void init() {
        WayfinderItems.items();
        WayfinderBlocks.blocks();
        WayfinderBlockEntityType.blockEntities();
        WayfinderSounds.sounds();
        WayfinderMemoryModuleType.memoryModuleTypes();
        WayfinderSensorType.sensorType();
        WayfinderEntityType.entities();
        WayfinderCriteriaTriggers.criteriaTriggers();
        WayfinderEntitySubPredicates.entitySubPredicates();
    }

    public static void onEntityLoad(Entity entity) {
        Monster monster;
        if (entity instanceof Monster && (monster = (Monster)entity).getType().is(WayfinderEntityTypeTags.SCARES_WAYFINDER)) {
            monster.goalSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)monster, WayfinderEntity.class, true));
        }
    }

    public static void registerEntityAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier> consumer) {
        consumer.accept(WayfinderEntityType.WAYFINDER.get(), WayfinderEntity.createAttributes().build());
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static <T> ResourceKey<T> key(ResourceKey<? extends Registry<T>> registryKey, String name) {
        return ResourceKey.create(registryKey, (ResourceLocation)Wayfinder.id(name));
    }
}

