/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.potionstudios.wayfinder.PlatformHandler;
import net.potionstudios.wayfinder.advancements.critereon.WayfinderCriteriaTriggers;
import org.jetbrains.annotations.NotNull;

public class WayfinderGotToBiomeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(@NotNull ServerPlayer player, ResourceKey<Biome> biome, ResourceKey<Level> level, int distance) {
        super.trigger(player, triggerInstance -> triggerInstance.matches(player, biome, level, distance));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ResourceKey<Biome>> biome, Optional<ResourceKey<Level>> level, Optional<Integer> distance, Optional<Integer> threeKJourneys, Optional<String> modid) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).optionalFieldOf("biome").forGetter(TriggerInstance::biome), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).optionalFieldOf("level").forGetter(TriggerInstance::level), (App)Codec.INT.optionalFieldOf("distance").forGetter(TriggerInstance::distance), (App)Codec.INT.optionalFieldOf("three_k_journeys").forGetter(TriggerInstance::threeKJourneys), (App)Codec.STRING.optionalFieldOf("modid").forGetter(TriggerInstance::modid)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> gotToBiome() {
            return WayfinderCriteriaTriggers.WAYFINDER_GOT_TO_BIOME.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        }

        public static Criterion<TriggerInstance> gotToBiome(ResourceKey<Level> level) {
            return WayfinderCriteriaTriggers.WAYFINDER_GOT_TO_BIOME.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty(), Optional.of(level), Optional.empty(), Optional.empty(), Optional.empty()));
        }

        public static Criterion<TriggerInstance> gotToBiome(ResourceKey<Biome> biome, ResourceKey<Level> level, int distance) {
            return WayfinderCriteriaTriggers.WAYFINDER_GOT_TO_BIOME.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(biome), Optional.of(level), Optional.of(distance), Optional.empty(), Optional.empty()));
        }

        public static Criterion<TriggerInstance> gotToBiome(ResourceKey<Level> level, int distance) {
            return WayfinderCriteriaTriggers.WAYFINDER_GOT_TO_BIOME.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty(), Optional.of(level), Optional.of(distance), Optional.empty(), Optional.empty()));
        }

        public static Criterion<TriggerInstance> gotToBiome(int distance, int threeKJourneys) {
            return WayfinderCriteriaTriggers.WAYFINDER_GOT_TO_BIOME.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(distance), Optional.of(threeKJourneys), Optional.empty()));
        }

        public static Criterion<TriggerInstance> gotToBiome(String modid) {
            return WayfinderCriteriaTriggers.WAYFINDER_GOT_TO_BIOME.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(modid)));
        }

        public boolean matches(ServerPlayer player, ResourceKey<Biome> biome, ResourceKey<Level> level, int distance) {
            return this.biome.map(b -> b.equals(biome)).orElse(true) != false && this.level.map(l -> l.equals(level)).orElse(true) != false && this.distance.map(d -> d <= distance).orElse(true) != false && this.threeKJourneys.map(t -> t.intValue() == PlatformHandler.PLATFORM_HANDLER.get3kJourneys((Player)player)).orElse(true) != false && this.modid.map(m -> biome.location().getNamespace().equals(m)).orElse(true) != false;
        }
    }
}

