/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.client.gui.screens;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

class BiomeList
extends ContainerObjectSelectionList<Entry> {
    BiomeList(Minecraft minecraft, int width, int height, int y, int itemHeight) {
        super(minecraft, width, height, y, itemHeight);
    }

    public void setBiomes(@NotNull List<ResourceLocation> biomes) {
        this.clearEntries();
        if (biomes.isEmpty()) {
            return;
        }
        biomes.stream().sorted().forEach(biome -> this.addEntry((AbstractSelectionList.Entry)new Entry((ResourceLocation)biome)));
    }

    protected void renderListBackground(@NotNull GuiGraphics guiGraphics) {
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.getWidth();
    }

    class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private final String biomeName;
        private final ResourceLocation biome;

        public Entry(ResourceLocation location) {
            this.biome = location;
            this.biomeName = Component.translatable((String)("biome." + location.toLanguageKey())).getString();
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            boolean b;
            boolean bl = b = hovered || BiomeList.this.getSelected() == BiomeList.this.getEntry(index);
            if (BiomeList.this.getSelected() == BiomeList.this.getEntry(index)) {
                guiGraphics.fill(x, y - 3, x + width, y + height + 3, -2143272896);
            }
            guiGraphics.drawString(((BiomeList)BiomeList.this).minecraft.font, this.biomeName, x + 50, y, b ? 0xFFFFA0 : 0, b);
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return List.of();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (BiomeList.this.getSelected() == this) {
                BiomeList.this.setSelected(null);
            } else {
                BiomeList.this.setSelected((AbstractSelectionList.Entry)this);
            }
            return true;
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return List.of();
        }

        public ResourceLocation getBiome() {
            return this.biome;
        }
    }
}

