/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.client.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractScrollWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class ScrollableTextWidget
extends AbstractScrollWidget {
    private final List<FormattedCharSequence> wrappedLines;
    private static final int LINE_HEIGHT = 9;

    public ScrollableTextWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, (Component)Component.empty());
        this.wrappedLines = new ArrayList<FormattedCharSequence>(Minecraft.getInstance().font.split((FormattedText)message, width - this.scrollbarWidth() - 6));
    }

    protected int getInnerHeight() {
        return this.wrappedLines.size() * 9;
    }

    protected double scrollRate() {
        return 4.5;
    }

    public int scrollbarWidth() {
        return 6;
    }

    protected void renderContents(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack pose = guiGraphics.pose();
        guiGraphics.enableScissor(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight());
        pose.pushPose();
        pose.translate(0.0, -this.scrollAmount(), 0.0);
        for (int i = 0; i < this.wrappedLines.size(); ++i) {
            int drawY = this.getY() + i * 9 + 2;
            guiGraphics.drawString(Minecraft.getInstance().font, this.wrappedLines.get(i), this.getX() + 4, drawY, 0, false);
        }
        pose.popPose();
        guiGraphics.disableScissor();
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    protected void renderBackground(@NotNull GuiGraphics guiGraphics) {
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.getWidth()) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.getHeight());
    }
}

