/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.client.gui.screens;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.potionstudios.wayfinder.PlatformHandler;
import net.potionstudios.wayfinder.Wayfinder;
import net.potionstudios.wayfinder.client.gui.screens.BiomeList;
import net.potionstudios.wayfinder.client.gui.screens.ScrollableTextWidget;
import net.potionstudios.wayfinder.network.packets.WayfinderBiomePacket;
import net.potionstudios.wayfinder.network.packets.WayfinderSitPacket;
import org.jetbrains.annotations.NotNull;

public class WayfinderScreen
extends Screen {
    private static final ResourceLocation BOOK_TEXTURE = Wayfinder.id("textures/gui/book_gui.png");
    private static final ResourceLocation LOGO = Wayfinder.id("textures/gui/wayfinder.png");
    protected static final int IMAGE_WIDTH = 288;
    protected static final int IMAGE_HEIGHT = 208;
    protected int leftPos;
    protected int bottomPos;
    protected int rightPos;
    protected int topPos;
    protected int startXRightPage;
    protected int startXLeftPage;
    private final List<ResourceLocation> biomes;
    private boolean isSitting;
    private final boolean wasSitting;
    private BiomeList biomeList;
    private ResourceLocation current;

    public WayfinderScreen(List<ResourceLocation> biomeRegistry, ResourceLocation current, boolean isSitting) {
        super((Component)Component.literal((String)""));
        this.biomes = biomeRegistry;
        this.isSitting = isSitting;
        this.current = current;
        this.wasSitting = isSitting;
    }

    protected void init() {
        this.leftPos = (this.width - 288) / 2;
        this.bottomPos = (this.height - 208) / 2 - 15;
        this.rightPos = this.leftPos + 288;
        this.topPos = this.bottomPos + 208;
        this.startXRightPage = this.leftPos + 72 + 96 - 18;
        this.startXLeftPage = this.leftPos + 15;
        EditBox searchBox = new EditBox(this.font, 119, 15, (Component)Component.translatable((String)"gui.wayfinder.search"));
        searchBox.setPosition(this.rightPos - 144 + 10, this.topPos - 208 + 10);
        searchBox.setResponder(this::updateBiomeList);
        this.addRenderableWidget((GuiEventListener)searchBox);
        ScrollableTextWidget descriptionWidget = new ScrollableTextWidget(this.leftPos + 10, this.topPos + 10, 116, 86, (Component)Component.translatable((String)"gui.wayfinder.description"));
        descriptionWidget.setPosition(this.leftPos + 15, 100 + (this.bottomPos + 52 - 50) - 23);
        this.addRenderableWidget((GuiEventListener)descriptionWidget);
        this.biomeList = new BiomeList(this.minecraft, 119, 138, 0, 10);
        this.biomeList.setPosition(this.rightPos - 144 + 10, this.topPos - 208 + 28);
        this.biomeList.setBiomes(this.biomes);
        this.addRenderableWidget((GuiEventListener)this.biomeList);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int logoWidth = 100;
        int logoHeight = 100;
        int centerX = this.leftPos + 72 - logoWidth / 2;
        int centerY = this.bottomPos + 52 - logoHeight / 2;
        guiGraphics.blit(LOGO, centerX, centerY, 0.0f, 0.0f, logoWidth, logoHeight, logoWidth, logoHeight);
        int buttonY = this.bottomPos + 208 - 40;
        Button submitButton = new Button(this.rightPos - 144 + 10, buttonY, 50, 20, (Component)Component.translatable((String)"gui.wayfinder.button.search"), button -> {
            PlatformHandler.PLATFORM_HANDLER.sendToServer(new WayfinderBiomePacket(((BiomeList.Entry)this.biomeList.getFocused()).getBiome()));
            this.onClose();
        }, Button.DEFAULT_NARRATION);
        submitButton.active = this.biomeList.getFocused() != null;
        this.addRenderableWidget((GuiEventListener)submitButton);
        Button stopButton = new Button(this.rightPos - 70, buttonY, 50, 20, (Component)Component.translatable((String)"gui.wayfinder.button.stop"), button -> {
            PlatformHandler.PLATFORM_HANDLER.sendToServer(new WayfinderBiomePacket(Wayfinder.id("clear_packet")));
            this.current = Wayfinder.id("clear_packet");
        }, Button.DEFAULT_NARRATION);
        stopButton.active = !this.current.equals((Object)Wayfinder.id("clear_packet"));
        this.addRenderableWidget((GuiEventListener)stopButton);
        int buttonXLeft = this.leftPos + 20;
        int buttonXRight = this.leftPos + 144 - 60;
        Button sitButton = new Button(buttonXLeft, buttonY, 50, 20, (Component)Component.translatable((String)"gui.wayfinder.button.sit"), button -> {
            this.isSitting = true;
        }, Button.DEFAULT_NARRATION);
        sitButton.active = !this.isSitting;
        this.addRenderableWidget((GuiEventListener)sitButton);
        Button walkButton = new Button(buttonXRight, buttonY, 50, 20, (Component)Component.translatable((String)"gui.wayfinder.button.follow"), button -> {
            this.isSitting = false;
        }, Button.DEFAULT_NARRATION);
        walkButton.active = this.isSitting;
        this.addRenderableWidget((GuiEventListener)walkButton);
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(BOOK_TEXTURE, this.leftPos, this.bottomPos, 0.0f, 0.0f, 288, 208, 288, 208);
    }

    public void onClose() {
        super.onClose();
        if (this.isSitting != this.wasSitting) {
            PlatformHandler.PLATFORM_HANDLER.sendToServer(new WayfinderSitPacket(this.isSitting));
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return this.biomeList.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (super.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return this.biomeList.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return this.biomeList.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return this.biomeList.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public static void openScreen(List<ResourceLocation> biomeRegistry, ResourceLocation current, boolean isSitting) {
        Minecraft.getInstance().setScreen((Screen)new WayfinderScreen(biomeRegistry, current, isSitting));
    }

    private void updateBiomeList(String searchText) {
        this.biomeList.setBiomes(this.getFilteredBiomes(searchText));
    }

    private List<ResourceLocation> getFilteredBiomes(String searchText) {
        return this.biomes.stream().filter(biome -> biome.toLanguageKey().toLowerCase().contains(searchText.toLowerCase())).toList();
    }
}

