/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.potionstudios.wayfinder.PlatformHandler;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;

class WayfinderLocateCommand {
    WayfinderLocateCommand() {
    }

    static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder command = LiteralArgumentBuilder.literal((String)"locate");
        command.requires(commandSourceStack -> PlatformHandler.PLATFORM_HANDLER.hasPermission((CommandSourceStack)commandSourceStack, "wayfinder.commands.locate"));
        command.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            if (PlatformHandler.PLATFORM_HANDLER.hasWayfinder((Player)player)) {
                Entity patt0$temp = player.serverLevel().getEntity(PlatformHandler.PLATFORM_HANDLER.getWayfinder((Player)player));
                if (patt0$temp instanceof WayfinderEntity) {
                    WayfinderEntity wayfinder = (WayfinderEntity)patt0$temp;
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"wayfinder.commands.locate.self.success", (Object[])new Object[]{WayfinderLocateCommand.clickTeleport(wayfinder)}), false);
                    return 1;
                }
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"wayfinder.commands.locate.self.lost").withStyle(ChatFormatting.RED));
                return 0;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"wayfinder.commands.locate.self.nowayfinder").withStyle(ChatFormatting.RED));
            return 0;
        });
        command.then(RequiredArgumentBuilder.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(WayfinderLocateCommand::locateWayfinder));
        return command;
    }

    private static int locateWayfinder(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        if (PlatformHandler.PLATFORM_HANDLER.hasWayfinder((Player)player)) {
            Entity entity = player.serverLevel().getEntity(PlatformHandler.PLATFORM_HANDLER.getWayfinder((Player)player));
            if (entity instanceof WayfinderEntity) {
                WayfinderEntity wayfinder = (WayfinderEntity)entity;
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"wayfinder.commands.locate.other.success", (Object[])new Object[]{player.getDisplayName(), WayfinderLocateCommand.clickTeleport(wayfinder)}), false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"wayfinder.commands.locate.other.lost").withStyle(ChatFormatting.RED));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"wayfinder.commands.locate.other.nowayfinder", (Object[])new Object[]{player.getDisplayName()}).withStyle(ChatFormatting.RED));
        return 0;
    }

    private static Component clickTeleport(WayfinderEntity wayfinder) {
        BlockPos blockPos = wayfinder.blockPosition();
        return ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"chat.coordinates", (Object[])new Object[]{blockPos.getX(), blockPos.getY(), blockPos.getZ()})).withStyle(style -> style.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + blockPos.getX() + " " + blockPos.getY() + " " + blockPos.getZ())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.coordinates.tooltip"))));
    }
}

