/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.mixin;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.potionstudios.wayfinder.Wayfinder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={JigsawPlacement.Placer.class})
public abstract class JigsawPlacementMixin {
    @Shadow
    @Final
    private Registry<StructureTemplatePool> pools;
    @Unique
    private boolean wayfinder$hasShrine;

    @ModifyArg(method={"tryPlacingChildren(Lnet/minecraft/world/level/levelgen/structure/PoolElementStructurePiece;Lorg/apache/commons/lang3/mutable/MutableObject;IZLnet/minecraft/world/level/LevelHeightAccessor;Lnet/minecraft/world/level/levelgen/RandomState;Lnet/minecraft/world/level/levelgen/structure/pools/alias/PoolAliasLookup;Lnet/minecraft/world/level/levelgen/structure/templatesystem/LiquidSettings;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/Registry;getHolder(Lnet/minecraft/resources/ResourceKey;)Ljava/util/Optional;"))
    private ResourceKey<StructureTemplatePool> forceShrinePool(ResourceKey<StructureTemplatePool> resourceKey) {
        ResourceLocation wayfinderPoolName;
        ResourceKey wayfinderPoolKey;
        String poolPath;
        if (!this.wayfinder$hasShrine && (poolPath = resourceKey.location().getPath()).endsWith("/houses") && this.pools.getHolder(wayfinderPoolKey = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)(wayfinderPoolName = Wayfinder.id(poolPath.replace("/houses", "/wayfinder_shrine"))))).isPresent()) {
            this.wayfinder$hasShrine = true;
            return wayfinderPoolKey;
        }
        return resourceKey;
    }
}

