/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.network.packets;

import com.mojang.serialization.Codec;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.potionstudios.wayfinder.PlatformHandler;
import net.potionstudios.wayfinder.Wayfinder;
import net.potionstudios.wayfinder.world.entity.ai.memory.WayfinderMemoryModuleType;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.network.packet.MultiloaderPacket;

public record WayfinderBiomePacket(ResourceLocation biome) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<WayfinderBiomePacket> TYPE = new CustomPacketPayload.Type(Wayfinder.id("biome"));
    public static final StreamCodec<FriendlyByteBuf, WayfinderBiomePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)ResourceLocation.CODEC), WayfinderBiomePacket::biome, WayfinderBiomePacket::new);

    public void receiveMessage(@Nullable Player player, Consumer<Runnable> consumer) {
        consumer.accept(() -> {
            Entity entity = player.getServer().getLevel(player.getCommandSenderWorld().dimension()).getEntity(PlatformHandler.PLATFORM_HANDLER.getWayfinder(player));
            if (entity instanceof WayfinderEntity) {
                WayfinderEntity wayfinder = (WayfinderEntity)entity;
                if (this.biome.equals((Object)Wayfinder.id("clear_packet"))) {
                    wayfinder.getBrain().eraseMemory(WayfinderMemoryModuleType.JOURNEY_TARGET_POS.get());
                    wayfinder.playSound(SoundEvents.BOOK_PUT);
                } else {
                    wayfinder.startBiomeSearch(this.biome);
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

