/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.potionstudios.wayfinder.world.entity.ai.memory.WayfinderMemoryModuleType;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;
import org.jetbrains.annotations.NotNull;

public class FollowOwner
extends Behavior<WayfinderEntity> {
    private ServerPlayer owner;
    private int timeToRecalcPath;

    public FollowOwner() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED, WayfinderMemoryModuleType.JOURNEY_TARGET_POS.get(), (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull WayfinderEntity entity) {
        if (entity.unableToMoveToOwner()) {
            return false;
        }
        LivingEntity livingEntity = entity.getOwner();
        if (!(livingEntity instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (entity.distanceToSqr((Entity)player) < 30.0) {
            return false;
        }
        this.owner = player;
        return true;
    }

    protected void start(@NotNull ServerLevel level, @NotNull WayfinderEntity entity, long gameTime) {
        this.timeToRecalcPath = 0;
    }

    protected void stop(@NotNull ServerLevel level, @NotNull WayfinderEntity entity, long gameTime) {
        this.owner = null;
        entity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        entity.getNavigation().stop();
    }

    protected void tick(@NotNull ServerLevel level, @NotNull WayfinderEntity entity, long gameTime) {
        if (this.owner == null) {
            return;
        }
        if (this.timeToRecalcPath-- > 0) {
            return;
        }
        this.timeToRecalcPath = 10;
        if (entity.shouldTryTeleportToOwner()) {
            entity.tryToTeleportToOwner();
            entity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            return;
        }
        entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)this.owner, false), 1.5f, 2));
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull WayfinderEntity entity, long gameTime) {
        if (entity.unableToMoveToOwner()) {
            return false;
        }
        return entity.distanceToSqr((Entity)this.owner) > 16.0;
    }
}

