/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookAtOwner
extends Behavior<WayfinderEntity> {
    private int cooldown;
    @Nullable
    private ServerPlayer owner;

    public LookAtOwner() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull WayfinderEntity entity) {
        ServerPlayer player;
        LivingEntity livingEntity = entity.getOwner();
        if (!(livingEntity instanceof ServerPlayer) || (player = (ServerPlayer)livingEntity).isDeadOrDying()) {
            return false;
        }
        if (entity.distanceToSqr((Entity)player) > 64.0) {
            return false;
        }
        this.owner = player;
        return true;
    }

    protected void start(@NotNull ServerLevel level, @NotNull WayfinderEntity entity, long gameTime) {
        this.cooldown = 0;
    }

    protected void tick(@NotNull ServerLevel level, @NotNull WayfinderEntity entity, long gameTime) {
        if (this.cooldown-- > 0 || this.owner == null) {
            return;
        }
        this.cooldown = 5;
        entity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)this.owner, true));
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull WayfinderEntity entity, long gameTime) {
        return this.owner != null && this.owner.isAlive() && entity.distanceToSqr((Entity)this.owner) < 64.0;
    }

    protected void stop(@NotNull ServerLevel level, @NotNull WayfinderEntity entity, long gameTime) {
        this.owner = null;
        entity.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
    }
}

