/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.wayfinder.advancements.critereon.WayfinderCriteriaTriggers;
import net.potionstudios.wayfinder.world.entity.ai.memory.WayfinderMemoryModuleType;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;
import org.jetbrains.annotations.NotNull;

public class TravelToJourneyTarget
extends Behavior<WayfinderEntity> {
    private int timeToRecalc;

    public TravelToJourneyTarget() {
        super((Map)ImmutableMap.of(WayfinderMemoryModuleType.JOURNEY_TARGET_POS.get(), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryStatus.REGISTERED));
    }

    protected void start(@NotNull ServerLevel level, @NotNull WayfinderEntity entity, long gameTime) {
        this.timeToRecalc = 0;
        entity.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
    }

    protected void tick(@NotNull ServerLevel level, @NotNull WayfinderEntity entity, long gameTime) {
        if (this.timeToRecalc-- > 0) {
            return;
        }
        this.timeToRecalc = 10;
        Brain<WayfinderEntity> brain = entity.getBrain();
        BlockPos target = brain.getMemory(WayfinderMemoryModuleType.JOURNEY_TARGET_POS.get()).orElse(null);
        if (target == null) {
            return;
        }
        Vec3 to = Vec3.atCenterOf((Vec3i)target).subtract(entity.position());
        double dist = to.length();
        if (dist <= 4.0) {
            int completedDistance = entity.getStartBlockPos().isPresent() ? (int)entity.getStartBlockPos().get().distSqr((Vec3i)target) : 0;
            WayfinderCriteriaTriggers.WAYFINDER_GOT_TO_BIOME.get().trigger((ServerPlayer)entity.getOwner(), (ResourceKey<Biome>)((ResourceKey)level.getBiome(target).unwrapKey().get()), (ResourceKey<Level>)level.dimension(), completedDistance);
            entity.incrementCompletedJourneys((ServerPlayer)entity.getOwner(), completedDistance);
            entity.setStartBlockPos(Optional.empty());
            brain.eraseMemory(WayfinderMemoryModuleType.JOURNEY_TARGET_POS.get());
            this.stop(level, entity, gameTime);
        } else if (entity.getOwner() == null || entity.getOwner().isDeadOrDying()) {
            entity.setStartBlockPos(Optional.empty());
            brain.eraseMemory(WayfinderMemoryModuleType.JOURNEY_TARGET_POS.get());
            this.stop(level, entity, gameTime);
        } else if (entity.distanceToSqr((Entity)entity.getOwner()) > 100.0) {
            brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        } else {
            Vec3 step = entity.position().add(to.normalize().scale(Math.min(24.0, dist)));
            BlockPos stepPos = BlockPos.containing((Position)step);
            brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(stepPos, 1.2f, 3));
        }
        brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
    }

    protected void stop(@NotNull ServerLevel level, @NotNull WayfinderEntity entity, long gameTime) {
        entity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        entity.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull WayfinderEntity entity, long gameTime) {
        return entity.getBrain().hasMemoryValue(WayfinderMemoryModuleType.JOURNEY_TARGET_POS.get());
    }
}

