/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;
import org.jetbrains.annotations.NotNull;

public class WayfinderPanicTrigger
extends Behavior<WayfinderEntity> {
    public WayfinderPanicTrigger() {
        super((Map)ImmutableMap.of());
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull WayfinderEntity entity, long gameTime) {
        return WayfinderPanicTrigger.dangerNear((LivingEntity)entity) || WayfinderPanicTrigger.isHurt((LivingEntity)entity);
    }

    protected void start(@NotNull ServerLevel level, @NotNull WayfinderEntity entity, long gameTime) {
        if (WayfinderPanicTrigger.isHurt((LivingEntity)entity) || WayfinderPanicTrigger.dangerNear((LivingEntity)entity)) {
            Brain<WayfinderEntity> brain = entity.getBrain();
            if (!brain.isActive(Activity.PANIC)) {
                brain.eraseMemory(MemoryModuleType.WALK_TARGET);
            }
            brain.setMemoryWithExpiry(MemoryModuleType.IS_PANICKING, (Object)true, 200L);
        }
    }

    public static boolean dangerNear(LivingEntity entity) {
        return entity.getBrain().hasMemoryValue(MemoryModuleType.DANGER_DETECTED_RECENTLY);
    }

    private static boolean isHurt(LivingEntity entity) {
        return entity.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY);
    }
}

