/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.world.entity.wayfinder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.potionstudios.wayfinder.world.entity.ai.behavior.CloseScreenOnPanic;
import net.potionstudios.wayfinder.world.entity.ai.behavior.FollowOwner;
import net.potionstudios.wayfinder.world.entity.ai.behavior.LookAtOwner;
import net.potionstudios.wayfinder.world.entity.ai.behavior.RegenerateShield;
import net.potionstudios.wayfinder.world.entity.ai.behavior.TravelToJourneyTarget;
import net.potionstudios.wayfinder.world.entity.ai.behavior.WayfinderPanicTrigger;
import net.potionstudios.wayfinder.world.entity.ai.memory.WayfinderMemoryModuleType;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;

public class WayfinderAi {
    protected static Brain<?> makeBrain(Brain<WayfinderEntity> brain) {
        WayfinderAi.initCoreActivity(brain);
        WayfinderAi.initWorkingActivity(brain);
        WayfinderAi.initIdleActivity(brain);
        WayfinderAi.initRestActivity(brain);
        WayfinderAi.initPanicActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        return brain;
    }

    private static void initCoreActivity(Brain<WayfinderEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)((Object)new WayfinderPanicTrigger()), (Object)new MoveToTargetSink(), (Object)new LookAtTargetSink(10, 50)));
    }

    private static void initWorkingActivity(Brain<WayfinderEntity> brain) {
        brain.addActivityWithConditions(Activity.WORK, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new TravelToJourneyTarget()))), Set.of(Pair.of(WayfinderMemoryModuleType.JOURNEY_TARGET_POS.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void initIdleActivity(Brain<WayfinderEntity> brain) {
        brain.addActivity(Activity.IDLE, 0, ImmutableList.of((Object)((Object)new FollowOwner()), (Object)((Object)new LookAtOwner())));
    }

    private static void initRestActivity(Brain<WayfinderEntity> brain) {
        brain.addActivityWithConditions(Activity.REST, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new RegenerateShield()))), Set.of(Pair.of(WayfinderMemoryModuleType.IS_RESTING.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void initPanicActivity(Brain<WayfinderEntity> brain) {
        brain.addActivityWithConditions(Activity.PANIC, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new CloseScreenOnPanic())), (Object)Pair.of((Object)1, (Object)new DoNothing(10, 100))), Set.of(Pair.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.HURT_BY, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.DANGER_DETECTED_RECENTLY, (Object)MemoryStatus.REGISTERED)));
    }

    protected static void updateActivity(WayfinderEntity wayfinder) {
        wayfinder.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.PANIC, (Object)Activity.REST, (Object)Activity.WORK, (Object)Activity.IDLE));
    }
}

