/*
 * Decompiled with CFR 0.152.
 */
package net.cafe.salinity.entity.custom;

import java.util.Optional;
import java.util.function.Predicate;
import net.cafe.salinity.block.ModBlocks;
import net.cafe.salinity.entity.ModEntities;
import net.cafe.salinity.item.ModItems;
import net.cafe.salinity.networking.packet.SodiumExplosionS2CPayload;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_10583;
import net.minecraft.class_10599;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_5362;
import net.minecraft.class_5454;
import net.minecraft.class_8046;
import net.minecraft.class_8567;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class SodiumBombEntity
extends class_1297
implements class_8046 {
    private static final class_2940<Integer> FUSE = class_2945.method_12791(SodiumBombEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2680> BLOCK_STATE = class_2945.method_12791(SodiumBombEntity.class, (class_2941)class_2943.field_13312);
    private static final class_2680 DEFAULT_BLOCK_STATE = class_2246.field_10375.method_9564();
    private static final Predicate<class_1297> IS_ALIVE = class_1297::method_5805;
    private static final class_5362 TELEPORTED_EXPLOSION_BEHAVIOR = new class_5362(){

        public boolean method_29554(class_1927 explosion, class_1922 world, class_2338 pos, class_2680 state, float power) {
            return state.method_27852(class_2246.field_10316) ? false : super.method_29554(explosion, world, pos, state, power);
        }

        public Optional<Float> method_29555(class_1927 explosion, class_1922 world, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
            return blockState.method_27852(class_2246.field_10316) ? Optional.empty() : super.method_29555(explosion, world, pos, blockState, fluidState);
        }
    };
    @Nullable
    private class_10583<class_1309> causingEntity;
    private boolean teleported;
    private float explosionPower = 4.0f;

    public SodiumBombEntity(class_1299<? extends SodiumBombEntity> type, class_1937 world) {
        super(type, world);
    }

    public SodiumBombEntity(class_1937 world, double x, double y, double z, @Nullable class_1309 igniter) {
        this(ModEntities.SODIUM_BOMB, world);
        this.method_5814(x, y, z);
        double d = world.field_9229.method_43058() * 6.2831854820251465;
        this.method_18800(-Math.sin(d) * 0.02, 0.2f, -Math.cos(d) * 0.02);
        this.setFuse(80);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
        this.causingEntity = class_10583.method_73299((class_10599)igniter);
    }

    public void method_5773() {
        this.method_60698();
        this.method_56990();
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_61409();
        this.method_18799(this.method_18798().method_1021(0.98));
        if (this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(0.7, -0.5, 0.7));
        }
        int i = this.getFuse() - 1;
        this.setFuse(i);
        if (i <= 0) {
            if (!this.method_73183().method_8608()) {
                this.explode();
                this.method_31472();
            }
        } else {
            this.method_5876();
            if (this.method_73183().method_8608()) {
                this.method_73183().method_8406((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void explode() {
        class_1937 world = this.method_73183();
        class_243 pos = new class_243(this.method_23317(), this.method_23318() + 0.5, this.method_23321());
        int r = 9;
        for (int x = -r; x < r; ++x) {
            for (int y = -r; y < r; ++y) {
                for (int z = -r; z < r; ++z) {
                    int i;
                    Object tntEntity;
                    Float distance;
                    class_243 blockPos = new class_243(pos.method_10216() + (double)x, pos.method_10214() + (double)y, pos.method_10215() + (double)z);
                    class_2338 block = class_2338.method_49638((class_2374)blockPos);
                    if (world.method_8320(block).method_26215() || !(world.method_8320(block).method_26204().method_9520() <= 1000.0f) || !((distance = Float.valueOf((float)Math.sqrt(Math.pow(pos.method_10216() - blockPos.method_10216(), 2.0) + Math.pow(pos.method_10214() - blockPos.method_10214(), 2.0) + Math.pow(pos.method_10215() - blockPos.method_10215(), 2.0)))).floatValue() <= (float)r)) continue;
                    if (world.method_8320(block).method_26204() == class_2246.field_10375) {
                        tntEntity = new class_1541(world, (double)block.method_10263() + 0.5, (double)block.method_10264(), (double)block.method_10260() + 0.5, null);
                        i = tntEntity.method_6969();
                        tntEntity.method_6967((int)((short)(world.field_9229.method_43048(i / 4) + i / 8)));
                        world.method_8649((class_1297)tntEntity);
                        world.method_8501(block, class_2246.field_10124.method_9564());
                        continue;
                    }
                    if (world.method_8320(block).method_26204() == ModBlocks.SODIUM_BOMB) {
                        tntEntity = new SodiumBombEntity(world, (double)block.method_10263() + 0.5, block.method_10264(), (double)block.method_10260() + 0.5, null);
                        i = ((SodiumBombEntity)((Object)tntEntity)).getFuse();
                        ((SodiumBombEntity)((Object)tntEntity)).setFuse((short)(world.field_9229.method_43048(i / 4) + i / 8));
                        world.method_8649((class_1297)tntEntity);
                        world.method_8501(block, class_2246.field_10124.method_9564());
                        continue;
                    }
                    if (this.field_5974.method_43058() >= 0.8 || world.method_8320(block).method_31709()) {
                        class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.method_73183()).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)block)).method_51874(class_181.field_1229, (Object)class_1799.field_8037);
                        world.method_8320(block).method_26189(builder).forEach(item -> {
                            class_1542 itemEntity = new class_1542(world, (double)block.method_10263(), (double)block.method_10264(), (double)block.method_10260(), item);
                            world.method_8649((class_1297)itemEntity);
                        });
                    }
                    world.method_31595(block, world.method_8320(block));
                    world.method_8501(block, class_2246.field_10124.method_9564());
                }
            }
        }
        class_238 box = class_238.method_29968((class_243)pos).method_1014(20.0);
        for (class_1297 entity : this.method_73183().method_8390(class_1309.class, box, IS_ALIVE)) {
            class_1309 livingEntity;
            if (!(entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_6118(class_1304.field_6169).method_31574(ModItems.SALAR_HELMET) && livingEntity.method_6118(class_1304.field_6174).method_31574(ModItems.SALAR_CHESTPLATE) && livingEntity.method_6118(class_1304.field_6172).method_31574(ModItems.SALAR_LEGGINGS) && livingEntity.method_6118(class_1304.field_6166).method_31574(ModItems.SALAR_BOOTS))) {
                double d = this.method_73189().method_1022(entity.method_73189());
                d = d >= 10.0 ? 10.0 : d;
                entity.method_64397((class_3218)world, this.method_48923().method_48819((class_1297)this, (class_1297)this.getOwner()), (float)(20.0 - d * 2.0));
            }
            if (entity instanceof class_1657) continue;
            this.knockBack(entity, this);
        }
        for (class_1657 player : world.method_18456()) {
            class_3222 serverPlayerEntity;
            if (!(player instanceof class_3222) || !((serverPlayerEntity = (class_3222)player).method_5707(pos) < 4096.0)) continue;
            ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new SodiumExplosionS2CPayload(pos));
        }
    }

    private void knockBack(class_1297 target, class_1297 attacker) {
        double d = target.method_23317() - attacker.method_23317();
        double e = target.method_23321() - attacker.method_23321();
        double r = target.method_23318() - attacker.method_23318();
        if (d < 0.35 && d > 0.0) {
            d = 0.35;
        } else if (d > -0.35 && d < 0.0) {
            d = -0.35;
        }
        if (e < 0.35 && e > 0.0) {
            e = 0.35;
        } else if (e > -0.35 && e < 0.0) {
            e = -0.35;
        }
        if (r < 0.35 && r > 0.0) {
            r = 0.35;
        } else if (r > -0.35 && r < 0.0) {
            r = -0.35;
        }
        double f = Math.max(d * d + e * e + r * r, 0.001);
        target.method_5762(d / f * 2.0, r / f * 2.0, e / f * 2.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(FUSE, (Object)80);
        builder.method_56912(BLOCK_STATE, (Object)DEFAULT_BLOCK_STATE);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    protected double method_7490() {
        return 0.04;
    }

    protected void method_5652(class_11372 view) {
        view.method_71471("fuse", (short)this.getFuse());
        view.method_71468("block_state", class_2680.field_24734, (Object)this.getBlockState());
        if (this.explosionPower != 4.0f) {
            view.method_71464("explosion_power", this.explosionPower);
        }
        class_10583.method_71612(this.causingEntity, (class_11372)view, (String)"owner");
    }

    protected void method_5749(class_11368 view) {
        this.setFuse(view.method_71432("fuse", (short)80));
        this.setBlockState(view.method_71426("block_state", class_2680.field_24734).orElse(DEFAULT_BLOCK_STATE));
        this.causingEntity = class_10583.method_66262((class_11368)view, (String)"owner");
    }

    @Nullable
    public class_1309 getOwner() {
        return (class_1309)class_10583.method_66254(this.causingEntity, (class_1937)this.method_73183(), class_1309.class);
    }

    public void method_5878(class_1297 original) {
        super.method_5878(original);
        if (original instanceof SodiumBombEntity) {
            SodiumBombEntity tntEntity = (SodiumBombEntity)original;
            this.causingEntity = tntEntity.causingEntity;
        }
    }

    public void setFuse(int fuse) {
        this.field_6011.method_12778(FUSE, (Object)fuse);
    }

    public int getFuse() {
        return (Integer)this.field_6011.method_12789(FUSE);
    }

    public void setBlockState(class_2680 state) {
        this.field_6011.method_12778(BLOCK_STATE, (Object)state);
    }

    public class_2680 getBlockState() {
        return (class_2680)this.field_6011.method_12789(BLOCK_STATE);
    }

    private void setTeleported(boolean teleported) {
        this.teleported = teleported;
    }

    @Nullable
    public class_1297 method_5731(class_5454 teleportTarget) {
        class_1297 entity = super.method_5731(teleportTarget);
        if (entity instanceof SodiumBombEntity) {
            SodiumBombEntity tntEntity = (SodiumBombEntity)entity;
            tntEntity.setTeleported(true);
        }
        return entity;
    }

    public final boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return false;
    }
}

