/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FogMessages {
    private static final List<String> MORSE_MESSAGES = Arrays.asList("HELLO FOG IS LOOKING FOR YOU", "THE FOG IS COMING", "DONT LOOK INTO THE FOG", "IT WATCHES YOU", "CAN YOU HEAR IT", "THE FOG IS NEAR", "WHISPERS IN THE MIST", "YOU CANT ESCAPE", "IT KNOWS WHERE YOU ARE", "THE FOG HUNGERS", "LOST IN THE MIST", "VOICES IN THE FOG", "IT GETS CLOSER", "THE FOG IS ALIVE", "YOU ARE NOT ALONE", "IT SEES THROUGH THE FOG", "THE MIST MOVES", "YOUR TIME IS NEAR", "THE FOG AWAITS", "ESCAPE IS IMPOSSIBLE");
    private static final List<String> PLAYER_MESSAGES = Arrays.asList("I cant take this anymore", "The fog is getting closer", "I hear whispers", "Something is watching me", "Im not alone here", "The fog is moving", "I need to get out", "Its coming for me", "I see shapes in the fog", "The mist is alive", "I cant breathe", "It knows Im here", "The fog is everywhere", "Im scared", "Its getting hard to see", "The voices wont stop", "I feel it nearby", "The fog is hunting me", "I need to hide", "Its almost here");
    private static final Map<Character, String> MORSE_CODE = new HashMap<Character, String>();
    private static int tickCounter;
    private static final int TICKS_PER_5_MINUTES = 6000;
    private static final double CHANCE = 0.3;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        block7: {
            if (event.phase != TickEvent.Phase.END || ++tickCounter < 6000) break block7;
            tickCounter = 0;
            Random random = new Random();
            if (random.nextDouble() < 0.3) {
                boolean isMorseMessage = random.nextBoolean();
                List allPlayers = event.getServer().m_6846_().m_11314_();
                if (allPlayers.isEmpty()) {
                    return;
                }
                if (isMorseMessage) {
                    String message = MORSE_MESSAGES.get(random.nextInt(MORSE_MESSAGES.size()));
                    String morse = FogMessages.convertToMorse(message);
                    for (ServerPlayer player : allPlayers) {
                        player.m_213846_((Component)Component.m_237113_((String)morse).m_130938_(style -> style.m_178520_(0xFF5555)));
                    }
                } else {
                    for (ServerPlayer player : allPlayers) {
                        String localMessage = PLAYER_MESSAGES.get(random.nextInt(PLAYER_MESSAGES.size()));
                        player.m_213846_((Component)Component.m_237113_((String)("[" + player.m_5446_().getString() + "] " + localMessage)).m_130938_(style -> style.m_178520_(0xAAAAAA)));
                        AABB area = new AABB(player.m_20185_() - 32.0, player.m_20186_() - 32.0, player.m_20189_() - 32.0, player.m_20185_() + 32.0, player.m_20186_() + 32.0, player.m_20189_() + 32.0);
                        List nearbyPlayers = player.m_284548_().m_6443_(ServerPlayer.class, area, nearbyPlayer -> nearbyPlayer != player);
                        for (ServerPlayer nearbyPlayer2 : nearbyPlayers) {
                            nearbyPlayer2.m_213846_((Component)Component.m_237113_((String)("[" + player.m_5446_().getString() + "] " + localMessage)).m_130938_(style -> style.m_178520_(0xAAAAAA)));
                        }
                    }
                }
            }
        }
    }

    private static String convertToMorse(String text) {
        text = text.toUpperCase();
        StringBuilder morse = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (!MORSE_CODE.containsKey(Character.valueOf(c))) continue;
            morse.append(MORSE_CODE.get(Character.valueOf(c))).append(" ");
        }
        return morse.toString().trim();
    }

    static {
        MORSE_CODE.put(Character.valueOf('A'), ".-");
        MORSE_CODE.put(Character.valueOf('B'), "-...");
        MORSE_CODE.put(Character.valueOf('C'), "-.-.");
        MORSE_CODE.put(Character.valueOf('D'), "-..");
        MORSE_CODE.put(Character.valueOf('E'), ".");
        MORSE_CODE.put(Character.valueOf('F'), "..-.");
        MORSE_CODE.put(Character.valueOf('G'), "--.");
        MORSE_CODE.put(Character.valueOf('H'), "....");
        MORSE_CODE.put(Character.valueOf('I'), "..");
        MORSE_CODE.put(Character.valueOf('J'), ".---");
        MORSE_CODE.put(Character.valueOf('K'), "-.-");
        MORSE_CODE.put(Character.valueOf('L'), ".-..");
        MORSE_CODE.put(Character.valueOf('M'), "--");
        MORSE_CODE.put(Character.valueOf('N'), "-.");
        MORSE_CODE.put(Character.valueOf('O'), "---");
        MORSE_CODE.put(Character.valueOf('P'), ".--.");
        MORSE_CODE.put(Character.valueOf('Q'), "--.-");
        MORSE_CODE.put(Character.valueOf('R'), ".-.");
        MORSE_CODE.put(Character.valueOf('S'), "...");
        MORSE_CODE.put(Character.valueOf('T'), "-");
        MORSE_CODE.put(Character.valueOf('U'), "..-");
        MORSE_CODE.put(Character.valueOf('V'), "...-");
        MORSE_CODE.put(Character.valueOf('W'), ".--");
        MORSE_CODE.put(Character.valueOf('X'), "-..-");
        MORSE_CODE.put(Character.valueOf('Y'), "-.--");
        MORSE_CODE.put(Character.valueOf('Z'), "--..");
        MORSE_CODE.put(Character.valueOf(' '), "/");
        MORSE_CODE.put(Character.valueOf('0'), "-----");
        MORSE_CODE.put(Character.valueOf('1'), ".----");
        MORSE_CODE.put(Character.valueOf('2'), "..---");
        MORSE_CODE.put(Character.valueOf('3'), "...--");
        MORSE_CODE.put(Character.valueOf('4'), "....-");
        MORSE_CODE.put(Character.valueOf('5'), ".....");
        MORSE_CODE.put(Character.valueOf('6'), "-....");
        MORSE_CODE.put(Character.valueOf('7'), "--...");
        MORSE_CODE.put(Character.valueOf('8'), "---..");
        MORSE_CODE.put(Character.valueOf('9'), "----.");
        tickCounter = 0;
    }
}

