/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MobStareAtPlayer {
    private static final double RADIUS = 64.0;
    private static final int STARE_DURATION = 200;
    private static final int COOLDOWN_MIN = 6000;
    private static final double TRIGGER_CHANCE = 0.6;
    private static boolean isStaringPhase = false;
    private static int stareTimer = 0;
    private static int cooldownTimer = 6000;
    private static final Set<UUID> staringMobs = new HashSet<UUID>();
    private static final Map<UUID, Boolean> originalNoAiStates = new HashMap<UUID, Boolean>();
    private static final Random random = new Random();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (isStaringPhase) {
            if (--stareTimer <= 0) {
                MobStareAtPlayer.endStaringPhase();
            } else {
                MobStareAtPlayer.updateStaring(event.getServer());
            }
        } else if (--cooldownTimer <= 0) {
            if (random.nextDouble() < 0.6) {
                MobStareAtPlayer.startStaringPhase(event.getServer());
            } else {
                cooldownTimer = 400;
            }
        }
    }

    private static void startStaringPhase(MinecraftServer server) {
        isStaringPhase = true;
        stareTimer = 200;
        staringMobs.clear();
        originalNoAiStates.clear();
        server.m_129785_().forEach(level -> {
            for (ServerPlayer player : level.m_6907_()) {
                AABB box = player.m_20191_().m_82400_(64.0);
                List mobs = level.m_45976_(Mob.class, box);
                for (Mob mob : mobs) {
                    if (!mob.m_6084_() || mob.m_21525_() || staringMobs.contains(mob.m_20148_()) || !mob.m_142582_((Entity)player)) continue;
                    originalNoAiStates.put(mob.m_20148_(), mob.m_21525_());
                    mob.m_21557_(true);
                    staringMobs.add(mob.m_20148_());
                    MobStareAtPlayer.instantIntenseLookAt(mob, (Player)player);
                    mob.m_20334_(0.0, 0.0, 0.0);
                    mob.m_21561_(false);
                    mob.m_6710_(null);
                }
            }
        });
    }

    private static void updateStaring(MinecraftServer server) {
        if ((200 - stareTimer) % 2 != 0) {
            return;
        }
        server.m_129785_().forEach(level -> {
            List players = level.m_6907_();
            if (players.isEmpty()) {
                return;
            }
            AABB searchBox = new AABB(-64.0, -64.0, -64.0, 64.0, 256.0, 64.0).m_82383_(((ServerPlayer)players.get(0)).m_20182_());
            List nearbyMobs = level.m_45976_(Mob.class, searchBox);
            for (Mob mob : nearbyMobs) {
                ServerPlayer target;
                if (!mob.m_6084_() || !staringMobs.contains(mob.m_20148_()) || (target = MobStareAtPlayer.findBestTarget(mob, players)) == null) continue;
                MobStareAtPlayer.intenseTracking(mob, (Player)target);
                mob.m_20334_(0.0, mob.m_20184_().f_82480_, 0.0);
                mob.m_21561_(false);
                mob.m_6710_(null);
            }
        });
    }

    private static void endStaringPhase() {
        isStaringPhase = false;
        cooldownTimer = 6000;
        staringMobs.forEach(uuid -> {});
        staringMobs.clear();
        originalNoAiStates.clear();
    }

    private static ServerPlayer findBestTarget(Mob mob, List<ServerPlayer> players) {
        ServerPlayer bestTarget = null;
        double bestScore = -1.0;
        for (ServerPlayer player : players) {
            Vec3 toMob;
            double distance;
            if (!player.m_6084_() || (distance = mob.m_20280_((Entity)player)) > 4096.0 || !mob.m_142582_((Entity)player)) continue;
            double score = 100.0 / (distance + 1.0);
            Vec3 playerLook = player.m_20154_();
            double dot = playerLook.m_82526_(toMob = mob.m_20182_().m_82546_(player.m_20182_()).m_82541_());
            if (dot > 0.5) {
                score *= 1.0 + dot;
            }
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestTarget = player;
        }
        return bestTarget;
    }

    private static void instantIntenseLookAt(Mob mob, Player player) {
        if (player == null) {
            return;
        }
        Vec3 mobEyes = mob.m_146892_();
        Vec3 playerEyes = player.m_146892_();
        Vec3 direction = playerEyes.m_82546_(mobEyes);
        double horizontalDist = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        if (horizontalDist < 0.001) {
            return;
        }
        float targetYaw = (float)(Math.atan2(direction.f_82481_, direction.f_82479_) * 57.29577951308232) - 90.0f;
        float targetPitch = (float)(-(Math.atan2(direction.f_82480_, horizontalDist) * 57.29577951308232));
        targetYaw = Mth.m_14177_((float)targetYaw);
        targetPitch = Mth.m_14036_((float)targetPitch, (float)-90.0f, (float)90.0f);
        mob.m_146922_(targetYaw);
        mob.m_146926_(targetPitch);
        mob.m_5616_(targetYaw);
        mob.m_5618_(targetYaw);
        mob.f_19859_ = targetYaw;
        mob.f_19860_ = targetPitch;
        mob.f_20886_ = targetYaw;
        mob.f_20884_ = targetYaw;
    }

    private static void intenseTracking(Mob mob, Player player) {
        if (player == null) {
            return;
        }
        Vec3 mobEyes = mob.m_146892_();
        Vec3 playerEyes = player.m_146892_();
        Vec3 direction = playerEyes.m_82546_(mobEyes);
        double horizontalDist = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        if (horizontalDist < 0.001) {
            return;
        }
        float targetYaw = (float)(Math.atan2(direction.f_82481_, direction.f_82479_) * 57.29577951308232) - 90.0f;
        float targetPitch = (float)(-(Math.atan2(direction.f_82480_, horizontalDist) * 57.29577951308232));
        targetYaw = Mth.m_14177_((float)targetYaw);
        targetPitch = Mth.m_14036_((float)targetPitch, (float)-90.0f, (float)90.0f);
        float currentYaw = mob.m_146908_();
        float newHeadYaw = targetYaw;
        float newPitch = targetPitch;
        float newBodyYaw = currentYaw + Mth.m_14177_((float)(targetYaw - currentYaw)) * 0.8f;
        mob.m_5616_(newHeadYaw);
        mob.m_5618_(newBodyYaw);
        mob.m_146922_(newBodyYaw);
        mob.m_146926_(newPitch);
        mob.f_20886_ = newHeadYaw;
        mob.f_20884_ = newBodyYaw;
        mob.f_19859_ = newBodyYaw;
        mob.f_19860_ = newPitch;
        mob.m_21563_().m_24950_(player.m_20185_(), player.m_20186_() + (double)player.m_20192_() * 0.8, player.m_20189_(), 180.0f, 0.0f);
    }

    public static boolean isStaringPhaseActive() {
        return isStaringPhase;
    }

    public static int getRemainingStareTime() {
        return isStaringPhase ? stareTimer / 20 : 0;
    }

    public static int getTimeUntilNextEvent() {
        return isStaringPhase ? 0 : cooldownTimer / 20;
    }
}

