/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="dont_look_into_the_fog", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SzadiSpawner {
    private static final Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();
    private static final int FOUR_MINUTES = 4800;
    private static final float SPAWN_CHANCE = 0.3f;
    private static final int ROTATION_SIM_TIME = 20;
    private static final int DESPAWN_TIME = 100;
    private static final int EFFECT_DURATION = 140;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.getServer() == null) {
            return;
        }
        for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
            PlayerData data = playerDataMap.computeIfAbsent(player.m_20148_(), k -> new PlayerData());
            SzadiSpawner.processPlayer(player, data);
        }
    }

    private static void processPlayer(ServerPlayer player, PlayerData data) {
        Level level = player.m_9236_();
        switch (data.actionStage) {
            case 1: {
                SzadiSpawner.playSound(player, level);
                SzadiSpawner.applySlownessEffect(player);
                player.m_146922_(data.targetYaw);
                player.m_146926_(player.m_146909_());
                player.f_8906_.m_9774_(player.m_20185_(), player.m_20186_(), player.m_20189_(), data.targetYaw, player.m_146909_());
                data.waitTicks = 0;
                data.actionStage = 2;
                break;
            }
            case 2: {
                ++data.waitTicks;
                if (data.waitTicks < 20) break;
                data.actionStage = 3;
                data.waitTicks = 0;
                break;
            }
            case 3: {
                SzadiSpawner.spawnEntity(player, level, data);
                data.waitTicks = 0;
                data.actionStage = 4;
                break;
            }
            case 4: {
                ++data.waitTicks;
                if (data.waitTicks < 100) break;
                SzadiSpawner.despawnEntity(data);
                data.actionStage = 0;
            }
        }
        if (data.actionStage == 0) {
            ++data.tickCounter;
            if (data.tickCounter >= 4800) {
                data.tickCounter = 0;
                if (Math.random() < (double)0.3f) {
                    float playerYaw = player.m_146908_();
                    double yawRad = Math.toRadians(playerYaw);
                    double lookX = -Math.sin(yawRad);
                    double lookZ = Math.cos(yawRad);
                    data.spawnX = player.m_20185_() - lookX * 2.0;
                    data.spawnZ = player.m_20189_() - lookZ * 2.0;
                    data.spawnY = player.m_20186_();
                    data.targetYaw = SzadiSpawner.normalizeAngle(playerYaw + 180.0f);
                    data.spawnedEntity = null;
                    data.actionStage = 1;
                }
            }
        }
    }

    private static void spawnEntity(ServerPlayer player, Level level, PlayerData data) {
        Entity entity;
        EntityType szadiType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("dont_look_into_the_fog", "szadi"));
        if (szadiType != null && (entity = szadiType.m_20615_(level)) != null) {
            entity.m_6034_(data.spawnX, data.spawnY, data.spawnZ);
            entity.m_20225_(true);
            entity.m_20331_(true);
            level.m_7967_(entity);
            data.spawnedEntity = entity;
        }
    }

    private static void despawnEntity(PlayerData data) {
        if (data.spawnedEntity != null) {
            data.spawnedEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            data.spawnedEntity = null;
        }
    }

    private static void applySlownessEffect(ServerPlayer player) {
        MobEffectInstance slowness = new MobEffectInstance(MobEffects.f_19597_, 140, 255, false, false, true);
        player.m_7292_(slowness);
    }

    private static void playSound(ServerPlayer player, Level level) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("dont_look_into_the_fog", "neckhurts"));
        if (sound != null) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private static float normalizeAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private static class PlayerData {
        int tickCounter = 0;
        int actionStage = 0;
        int waitTicks = 0;
        Entity spawnedEntity = null;
        double spawnX;
        double spawnY;
        double spawnZ;
        float targetYaw;

        private PlayerData() {
        }

        void reset() {
            this.tickCounter = 0;
            this.actionStage = 0;
            this.waitTicks = 0;
            this.spawnedEntity = null;
        }
    }
}

