/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.mcreator.dontlookintothefog.GlazaControl;
import net.mcreator.dontlookintothefog.init.DontLookIntoTheFogModEntities;
import net.mcreator.dontlookintothefog.init.DontLookIntoTheFogModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="dont_look_into_the_fog", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheGlazEncounter {
    private static int spawnTimer = 0;
    private static final int SPAWN_INTERVAL_TICKS = 20400;
    private static final int ENCOUNTER_DURATION_TICKS = 100;
    private static final int VISION_LOSS_TICK = 60;
    private static final int ENTITY_COUNT = 1;
    private static final Map<UUID, ClientCameraData> clientCameraData = new HashMap<UUID, ClientCameraData>();

    @SubscribeEvent
    public static void registerPackets(FMLCommonSetupEvent event) {
        GlazaControl.PACKET_HANDLER.registerMessage(100, VisionUpdatePacket.class, VisionUpdatePacket::encode, VisionUpdatePacket::decode, VisionUpdatePacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        GlazaControl.PACKET_HANDLER.registerMessage(101, CameraLockPacket.class, CameraLockPacket::encode, CameraLockPacket::decode, CameraLockPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        GlazaControl.PACKET_HANDLER.registerMessage(102, EntityDisappearPacket.class, EntityDisappearPacket::encode, EntityDisappearPacket::decode, EntityDisappearPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static class VisionUpdatePacket {
        private final UUID playerId;
        private final int newVisionState;
        private final int newRecoveryTimer;

        public VisionUpdatePacket(UUID playerId, int newVisionState, int newRecoveryTimer) {
            this.playerId = playerId;
            this.newVisionState = newVisionState;
            this.newRecoveryTimer = newRecoveryTimer;
        }

        public static void encode(VisionUpdatePacket msg, FriendlyByteBuf buf) {
            buf.m_130077_(msg.playerId);
            buf.writeInt(msg.newVisionState);
            buf.writeInt(msg.newRecoveryTimer);
        }

        public static VisionUpdatePacket decode(FriendlyByteBuf buf) {
            return new VisionUpdatePacket(buf.m_130259_(), buf.readInt(), buf.readInt());
        }

        public static void handle(VisionUpdatePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
            contextSupplier.get().enqueueWork(() -> {
                GlazaControl.PlayerVisionData data;
                Minecraft minecraft = Minecraft.m_91087_();
                if (minecraft.f_91074_ != null && minecraft.f_91074_.m_9236_().m_5776_() && minecraft.f_91074_.m_20148_().equals(msg.playerId) && (data = GlazaControl.getPlayerVisionData((Player)minecraft.f_91074_)) != null) {
                    data.visionState = msg.newVisionState;
                    data.recoveryTimer = msg.newRecoveryTimer;
                }
            });
            contextSupplier.get().setPacketHandled(true);
        }
    }

    public static class CameraLockPacket {
        private final UUID playerId;
        private final float yaw;
        private final float pitch;
        private final int duration;

        public CameraLockPacket(UUID playerId, float yaw, float pitch, int duration) {
            this.playerId = playerId;
            this.yaw = yaw;
            this.pitch = pitch;
            this.duration = duration;
        }

        public static void encode(CameraLockPacket msg, FriendlyByteBuf buf) {
            buf.m_130077_(msg.playerId);
            buf.writeFloat(msg.yaw);
            buf.writeFloat(msg.pitch);
            buf.writeInt(msg.duration);
        }

        public static CameraLockPacket decode(FriendlyByteBuf buf) {
            return new CameraLockPacket(buf.m_130259_(), buf.readFloat(), buf.readFloat(), buf.readInt());
        }

        public static void handle(CameraLockPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
            contextSupplier.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)contextSupplier.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                    Minecraft minecraft = Minecraft.m_91087_();
                    if (minecraft.f_91074_ != null && minecraft.f_91074_.m_20148_().equals(msg.playerId)) {
                        ClientCameraData data = clientCameraData.computeIfAbsent(msg.playerId, k -> new ClientCameraData());
                        data.targetYaw = msg.yaw;
                        data.targetPitch = msg.pitch;
                        data.lockDuration = msg.duration;
                        data.isCameraLocked = true;
                    }
                }
            });
            contextSupplier.get().setPacketHandled(true);
        }
    }

    public static class EntityDisappearPacket {
        private final UUID playerId;

        public EntityDisappearPacket(UUID playerId) {
            this.playerId = playerId;
        }

        public static void encode(EntityDisappearPacket msg, FriendlyByteBuf buf) {
            buf.m_130077_(msg.playerId);
        }

        public static EntityDisappearPacket decode(FriendlyByteBuf buf) {
            return new EntityDisappearPacket(buf.m_130259_());
        }

        public static void handle(EntityDisappearPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
            contextSupplier.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)contextSupplier.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                    clientCameraData.remove(msg.playerId);
                }
            });
            contextSupplier.get().setPacketHandled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    private static class GlazEncounterClientEvents {
        private GlazEncounterClientEvents() {
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ == null) {
                clientCameraData.clear();
                return;
            }
            UUID playerId = minecraft.f_91074_.m_20148_();
            ClientCameraData data = clientCameraData.get(playerId);
            if (data != null && data.isCameraLocked) {
                minecraft.f_91074_.m_146922_(data.targetYaw);
                minecraft.f_91074_.m_146926_(data.targetPitch);
                if (data.lockDuration > 0) {
                    --data.lockDuration;
                } else {
                    data.isCameraLocked = false;
                }
            }
        }
    }

    @Mod.EventBusSubscriber
    private static class GlazEncounterServerEvents {
        private static final List<DelayedTask> PENDING_TASKS = new ArrayList<DelayedTask>();

        private GlazEncounterServerEvents() {
        }

        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                PENDING_TASKS.removeIf(task -> {
                    MinecraftServer server;
                    boolean done = task.tick();
                    if (!done && (server = event.getServer()) != null && server.m_6846_().m_11259_(task.getPlayerId()) == null) {
                        return true;
                    }
                    return done;
                });
                if (++spawnTimer >= 20400) {
                    spawnTimer = 0;
                    MinecraftServer server = event.getServer();
                    if (server == null) {
                        return;
                    }
                    for (ServerPlayer player : server.m_6846_().m_11314_()) {
                        ServerLevel serverWorld;
                        if (player.m_5833_()) continue;
                        ServerLevel world = serverWorld = (ServerLevel)player.m_9236_();
                        RandomSource random = world.f_46441_;
                        if (world.m_46472_() != Level.f_46428_) continue;
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1, false, false));
                        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)DontLookIntoTheFogModSounds.THEGLAZENCOUNTER.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                        for (int i = 0; i < 1; ++i) {
                            Entity glaz;
                            double spawnX = player.m_20185_() + (random.m_188500_() * 2.0 - 1.0) * 3.0;
                            double spawnZ = player.m_20189_() + (random.m_188500_() * 2.0 - 1.0) * 3.0;
                            double spawnY = player.m_20186_() + 1.0 + random.m_188500_() * 1.5;
                            BlockPos spawnPos = new BlockPos((int)spawnX, (int)spawnY, (int)spawnZ);
                            EntityType glazType = (EntityType)DontLookIntoTheFogModEntities.THE_GLAZ.get();
                            if (glazType == null || (glaz = glazType.m_262496_(serverWorld, spawnPos, MobSpawnType.EVENT)) == null) continue;
                            float lookYaw = (float)Mth.m_14136_((double)(glaz.m_20189_() - player.m_20189_()), (double)(glaz.m_20185_() - player.m_20185_())) * 57.295776f - 90.0f;
                            float lookPitch = (float)Mth.m_14136_((double)(player.m_20186_() + (double)player.m_20192_() - glaz.m_20186_()), (double)Mth.m_14116_((float)((float)((glaz.m_20185_() - player.m_20185_()) * (glaz.m_20185_() - player.m_20185_()) + (glaz.m_20189_() - player.m_20189_()) * (glaz.m_20189_() - player.m_20189_()))))) * 57.295776f;
                            glaz.m_20242_(true);
                            glaz.m_20334_(0.0, 0.0, 0.0);
                            for (int j = 1; j <= 100; ++j) {
                                int finalJ = j;
                                PENDING_TASKS.add(new DelayedTask(j, () -> {
                                    if (glaz.m_6084_() && player.m_6084_()) {
                                        float newLookYaw = (float)Mth.m_14136_((double)(glaz.m_20189_() - player.m_20189_()), (double)(glaz.m_20185_() - player.m_20185_())) * 57.295776f - 90.0f;
                                        float newLookPitch = (float)Mth.m_14136_((double)(player.m_20186_() + (double)player.m_20192_() - glaz.m_20186_()), (double)Mth.m_14116_((float)((float)((glaz.m_20185_() - player.m_20185_()) * (glaz.m_20185_() - player.m_20185_()) + (glaz.m_20189_() - player.m_20189_()) * (glaz.m_20189_() - player.m_20189_()))))) * 57.295776f;
                                        glaz.m_146922_(newLookYaw);
                                        glaz.m_146926_(newLookPitch);
                                        glaz.m_5616_(newLookYaw);
                                    }
                                }, player.m_20148_()));
                            }
                            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_11689_.get(), SoundSource.AMBIENT, 1.0f, random.m_188501_() * 0.2f + 0.9f);
                            GlazaControl.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new CameraLockPacket(player.m_20148_(), lookYaw, -lookPitch, 100));
                            PENDING_TASKS.add(new DelayedTask(60, () -> {
                                GlazaControl.PlayerVisionData playerData;
                                if (server.m_6846_().m_11314_().contains(player) && (playerData = GlazaControl.getPlayerVisionData((Player)player)) != null) {
                                    int newVisionState = playerData.visionState;
                                    if (random.m_188499_()) {
                                        if (newVisionState < 1) {
                                            newVisionState = 1;
                                        }
                                    } else {
                                        newVisionState = 2;
                                    }
                                    if (newVisionState != playerData.visionState) {
                                        playerData.visionState = newVisionState;
                                        if (playerData.visionState == 2) {
                                            playerData.recoveryTimer = 2400;
                                        }
                                        GlazaControl.setPlayerVisionData((Player)player, playerData);
                                        GlazaControl.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new VisionUpdatePacket(player.m_20148_(), playerData.visionState, playerData.recoveryTimer));
                                    }
                                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123783_, glaz.m_20185_(), glaz.m_20186_() + (double)glaz.m_20192_() / 2.0, glaz.m_20189_(), 100, 1.0, 1.0, 1.0, 0.1);
                                }
                            }, player.m_20148_()));
                            PENDING_TASKS.add(new DelayedTask(100, () -> {
                                if (glaz.m_6084_()) {
                                    glaz.m_142687_(Entity.RemovalReason.DISCARDED);
                                    GlazaControl.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new EntityDisappearPacket(player.m_20148_()));
                                }
                            }, player.m_20148_()));
                        }
                    }
                }
            }
        }
    }

    private static class DelayedTask {
        final int delay;
        final Runnable task;
        int ticks = 0;
        final UUID playerId;

        public DelayedTask(int delay, Runnable task, UUID playerId) {
            this.delay = delay;
            this.task = task;
            this.playerId = playerId;
        }

        public boolean tick() {
            ++this.ticks;
            if (this.ticks >= this.delay) {
                this.task.run();
                return true;
            }
            return false;
        }

        public UUID getPlayerId() {
            return this.playerId;
        }
    }

    private static class ClientCameraData {
        boolean isCameraLocked = false;
        float targetPitch = 0.0f;
        float targetYaw = 0.0f;
        int lockDuration = 0;

        private ClientCameraData() {
        }
    }
}

