/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Eventdhor {
    private static int stepTimer = 0;
    private static int doorTimer = 0;
    private static int whisperTimer = 0;
    private static final int STEP_INTERVAL = 6000;
    private static final int DOOR_INTERVAL = 1200;
    private static final int WHISPER_INTERVAL = 6000;
    private static final Random random = new Random();
    private static long fogMessageTime = 0L;
    private static boolean showFogMessage = false;
    private static final int FOG_MESSAGE_DURATION = 5000;
    private static final List<String> EXIT_KEYWORDS = Arrays.asList("quit", "\u0432\u044b\u0439\u0442\u0438", "exit", "menu", "\u0433\u043b\u0430\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", "\u043e\u0442\u043c\u0435\u043d\u0430", "cancel", "disconnect", "\u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f", "\u0432\u044b\u0439\u0442\u0438 \u0432 \u0433\u043b\u0430\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", "\u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438 \u0432\u044b\u0439\u0442\u0438", "save and quit", "save and exit");

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ++doorTimer;
        ++whisperTimer;
        if (++stepTimer >= 6000) {
            stepTimer = 0;
            for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                if (player.m_9236_().f_46443_) continue;
                double offsetX = (random.nextDouble() - 0.5) * 24.0;
                double offsetY = (random.nextDouble() - 0.5) * 10.0;
                double offsetZ = (random.nextDouble() - 0.5) * 24.0;
                Vec3 soundPos = player.m_20182_().m_82520_(offsetX, offsetY, offsetZ);
                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)soundPos), SoundEvents.f_12614_, SoundSource.AMBIENT, 0.5f, 0.8f + random.nextFloat() * 0.4f);
            }
        }
        if (doorTimer >= 1200) {
            doorTimer = 0;
            if (random.nextFloat() < 0.03f) {
                for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                    if (player.m_9236_().f_46443_) continue;
                    BlockPos playerPos = player.m_20183_();
                    for (int i = 0; i < 3; ++i) {
                        BlockPos doorPos = playerPos.m_7918_(random.nextInt(25) - 12, random.nextInt(11) - 5, random.nextInt(25) - 12);
                        BlockState state = player.m_9236_().m_8055_(doorPos);
                        if (!(state.m_60734_() instanceof DoorBlock)) continue;
                        boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_) == false;
                        BlockState newState = (BlockState)state.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(open));
                        player.m_9236_().m_46597_(doorPos, newState);
                        if (state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER) {
                            BlockPos upperPos = doorPos.m_7494_();
                            BlockState upperState = player.m_9236_().m_8055_(upperPos);
                            if (upperState.m_60734_() instanceof DoorBlock) {
                                player.m_9236_().m_46597_(upperPos, (BlockState)upperState.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(open)));
                            }
                        }
                        player.m_9236_().m_5594_(null, doorPos, open ? SoundEvents.f_12627_ : SoundEvents.f_12626_, SoundSource.BLOCKS, 0.5f, 0.8f + random.nextFloat() * 0.4f);
                    }
                }
            }
        }
        if (whisperTimer >= 6000) {
            whisperTimer = 0;
            if (random.nextFloat() < 0.2f) {
                for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                    if (player.m_9236_().f_46443_) continue;
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 2));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0));
                    player.m_6469_(player.m_269291_().m_269425_(), 6.0f);
                    player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)SoundEvents.f_11742_.get(), SoundSource.AMBIENT, 1.0f, 0.8f);
                    Vec3 soundPos = player.m_20182_().m_82520_((random.nextDouble() - 0.5) * 8.0, (random.nextDouble() - 0.5) * 4.0, (random.nextDouble() - 0.5) * 8.0);
                    player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)soundPos), (SoundEvent)SoundEvents.f_11689_.get(), SoundSource.AMBIENT, 0.3f, 0.9f + random.nextFloat() * 0.2f);
                    fogMessageTime = System.currentTimeMillis();
                    showFogMessage = true;
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (showFogMessage && System.currentTimeMillis() - fogMessageTime > 5000L) {
            showFogMessage = false;
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderGui(RenderGuiEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Font font = mc.f_91062_;
        int width = event.getWindow().m_85445_();
        int height = event.getWindow().m_85446_();
        if (showFogMessage) {
            String message = "I can't take this anymore";
            int messageWidth = font.m_92895_(message);
            int x = (width - messageWidth) / 2;
            int y = height - 80;
            long elapsed = System.currentTimeMillis() - fogMessageTime;
            int alpha = 255;
            if (elapsed < 500L) {
                alpha = (int)(255.0f * ((float)elapsed / 500.0f));
            } else if (elapsed > 4500L) {
                alpha = (int)(255.0f * ((float)(5000L - elapsed) / 500.0f));
            }
            int color = alpha << 24 | 0xFF5555;
            int shadowColor = alpha << 24 | 0;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)message), x + 1, y + 1, shadowColor, false);
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)message), x, y, color, false);
        }
        if (mc.f_91066_.f_92063_) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof PauseScreen || screen instanceof TitleScreen || screen instanceof GenericDirtMessageScreen || screen instanceof LevelLoadingScreen || screen instanceof OptionsScreen && Minecraft.m_91087_().f_91073_ != null) {
            block0: for (Object obj : event.getListenersList()) {
                if (!(obj instanceof Button)) continue;
                Button button = (Button)obj;
                String buttonText = button.m_6035_().getString().toLowerCase();
                for (String keyword : EXIT_KEYWORDS) {
                    if (!buttonText.contains(keyword)) continue;
                    button.f_93623_ = false;
                    button.m_93650_(0.3f);
                    continue block0;
                }
            }
        }
    }
}

