/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dont_look_into_the_fog", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FogEventHandler {
    private static long lastSpawnTime = -1L;
    private static final int SPAWN_INTERVAL_TICKS = 24000;
    private static final int DESPAWN_DELAY_TICKS = 200;
    private static final Random RANDOM = new Random();
    private static final String NBT_DESPAWN_TIME_TAG = "DespawnTime";
    private static final ResourceLocation ENTITY_NOWHORE_RL = new ResourceLocation("dont_look_into_the_fog", "entitynowhore");
    private static final ResourceLocation AMBIENT_CAVE_RL = BuiltInRegistries.f_256894_.m_7981_((Object)((SoundEvent)SoundEvents.f_11689_.get()));

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.getServer() == null) {
            return;
        }
        ServerLevel level = event.getServer().m_129783_();
        if (level == null) {
            return;
        }
        long now = level.m_46467_();
        if (lastSpawnTime == -1L || now - lastSpawnTime >= 24000L) {
            lastSpawnTime = now;
            FogEventHandler.spawnEntities(level, now);
        }
        FogEventHandler.despawnEntities(level, now);
    }

    private static void spawnEntities(ServerLevel level, long now) {
        List players = level.m_6907_();
        if (players.isEmpty()) {
            return;
        }
        ServerPlayer p = (ServerPlayer)players.get(RANDOM.nextInt(players.size()));
        SoundEvent caveSound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(AMBIENT_CAVE_RL);
        if (caveSound != null) {
            level.m_5594_(null, BlockPos.m_274561_((double)p.m_20185_(), (double)p.m_20186_(), (double)p.m_20189_()), caveSound, SoundSource.AMBIENT, 2.0f, 1.0f);
        }
        MobEffectInstance blindness = new MobEffectInstance(MobEffects.f_19610_, 60, 0, false, false);
        MobEffectInstance slowness = new MobEffectInstance(MobEffects.f_19597_, 60, 1, false, false);
        for (ServerPlayer pl : players) {
            if (!(pl.m_20280_((Entity)p) <= 400.0)) continue;
            pl.m_7292_(blindness);
            pl.m_7292_(slowness);
        }
        EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(ENTITY_NOWHORE_RL);
        if (type == null) {
            System.err.println("Entity type not found: " + String.valueOf(ENTITY_NOWHORE_RL));
            return;
        }
        long despawnTime = now + 200L;
        for (int i = 0; i < 30; ++i) {
            double x = p.m_20185_() + (double)RANDOM.nextInt(30) - 15.0;
            double y = p.m_20186_();
            double z = p.m_20189_() + (double)RANDOM.nextInt(30) - 15.0;
            Entity entity = type.m_20615_((Level)level);
            if (entity == null) continue;
            entity.m_6027_(x, y, z);
            entity.getPersistentData().m_128356_(NBT_DESPAWN_TIME_TAG, despawnTime);
            level.m_7967_(entity);
        }
    }

    private static void despawnEntities(ServerLevel level, long now) {
        EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(ENTITY_NOWHORE_RL);
        if (type == null) {
            return;
        }
        ArrayList<Entity> toRemove = new ArrayList<Entity>();
        for (Entity e : level.m_8583_()) {
            CompoundTag tag;
            if (e.m_6095_() != type || !(tag = e.getPersistentData()).m_128441_(NBT_DESPAWN_TIME_TAG) || now < tag.m_128454_(NBT_DESPAWN_TIME_TAG)) continue;
            toRemove.add(e);
        }
        for (Entity e : toRemove) {
            e.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

