/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="dont_look_into_the_fog", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FogWelcomeMessage {
    private static final Map<String, Map<UUID, Boolean>> worldPlayerData = new HashMap<String, Map<UUID, Boolean>>();
    private static final Map<UUID, Integer> playerTimers = new HashMap<UUID, Integer>();
    private static final Random random = new Random();
    private static final String DATA_FILE = "config/fog_received_players.dat";

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            UUID playerId = player.m_20148_();
            String worldName = FogWelcomeMessage.getWorldName();
            System.out.println("[FogWelcome] Player " + player.m_7755_().getString() + " joined world: " + worldName);
            FogWelcomeMessage.loadReceivedPlayers();
            if (!FogWelcomeMessage.hasPlayerReceivedItemsInWorld(playerId, worldName)) {
                playerTimers.put(playerId, 0);
                System.out.println("[FogWelcome] Timer started for " + player.m_7755_().getString() + " in world " + worldName);
            } else {
                System.out.println("[FogWelcome] Player " + player.m_7755_().getString() + " already received items in world " + worldName);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ServerLifecycleHooks.getCurrentServer() != null) {
            Iterator<Map.Entry<UUID, Integer>> iterator = playerTimers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, Integer> entry = iterator.next();
                UUID playerId = entry.getKey();
                int timer = entry.getValue() + 1;
                ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerId);
                if (player != null && player.m_6084_() && !player.m_9232_()) {
                    if (timer >= 200) {
                        FogWelcomeMessage.giveItemsToPlayer(player);
                        iterator.remove();
                        System.out.println("[FogWelcome] Items given to " + player.m_7755_().getString());
                        continue;
                    }
                    playerTimers.put(playerId, timer);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private static void giveItemsToPlayer(ServerPlayer player) {
        try {
            UUID playerId = player.m_20148_();
            String worldName = FogWelcomeMessage.getWorldName();
            if (FogWelcomeMessage.hasPlayerReceivedItemsInWorld(playerId, worldName)) {
                System.out.println("[FogWelcome] Player already received items in this world. Skipping.");
                return;
            }
            player.m_213846_((Component)Component.m_237113_((String)"DO NOT USE SHADERS THAT CHANGE THE FOG, AS THIS MAY NEGATIVELY AFFECT GAMEPLAY. Prove that you are not crazy and that the fog really exists. Use glaza if your eyes have been stolen by the fog.If you don't see the hotbar, press F3.Do not play with shaders that alter fog. Press G for skbidi "));
            FogWelcomeMessage.giveItems(player);
            FogWelcomeMessage.markPlayerAsReceived(playerId, worldName);
            FogWelcomeMessage.saveReceivedPlayers();
            System.out.println("[FogWelcome] Items successfully given to " + player.m_7755_().getString() + " in world " + worldName);
        }
        catch (Exception e) {
            System.out.println("[FogWelcome] Error giving items: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void giveItems(ServerPlayer player) {
        int stringCount = 1 + random.nextInt(4);
        ItemStack stringStack = new ItemStack((ItemLike)Items.f_42401_, stringCount);
        FogWelcomeMessage.safeAddItem(player, stringStack);
        ItemStack spiderEyeStack = new ItemStack((ItemLike)Items.f_42591_, 1);
        FogWelcomeMessage.safeAddItem(player, spiderEyeStack);
        ItemStack receprStack = FogWelcomeMessage.findReceprItem();
        if (receprStack != null) {
            FogWelcomeMessage.safeAddItem(player, receprStack);
        } else {
            System.out.println("[FogWelcome] Recepr item not found!");
        }
        player.f_36096_.m_38946_();
    }

    private static void safeAddItem(ServerPlayer player, ItemStack stack) {
        if (!player.m_150109_().m_36054_(stack)) {
            player.m_36176_(stack, false);
        }
    }

    private static ItemStack findReceprItem() {
        ResourceLocation[] possibleIds;
        for (ResourceLocation rl : possibleIds = new ResourceLocation[]{new ResourceLocation("dont_look_into_the_fog", "recepr"), new ResourceLocation("dontlookintothefog", "recepr")}) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
            if (item == null || item == Items.f_41852_) continue;
            return new ItemStack((ItemLike)item);
        }
        return null;
    }

    private static String getWorldName() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            File serverDir = ServerLifecycleHooks.getCurrentServer().m_6237_();
            return serverDir.getAbsolutePath();
        }
        return "unknown_world";
    }

    private static synchronized void loadReceivedPlayers() {
        block7: {
            try {
                Path dataPath = Paths.get(DATA_FILE, new String[0]);
                if (!Files.exists(dataPath, new LinkOption[0])) break block7;
                try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(dataPath.toFile()));){
                    worldPlayerData.clear();
                    Map loadedData = (Map)ois.readObject();
                    worldPlayerData.putAll(loadedData);
                    System.out.println("[FogWelcome] Loaded data for " + worldPlayerData.size() + " worlds");
                }
            }
            catch (Exception e) {
                System.out.println("[FogWelcome] Could not load player data: " + e.getMessage());
                worldPlayerData.clear();
            }
        }
    }

    private static synchronized void saveReceivedPlayers() {
        try {
            Path dataPath = Paths.get(DATA_FILE, new String[0]);
            Files.createDirectories(dataPath.getParent(), new FileAttribute[0]);
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(dataPath.toFile()));){
                oos.writeObject(worldPlayerData);
                System.out.println("[FogWelcome] Saved data for " + worldPlayerData.size() + " worlds");
            }
        }
        catch (Exception e) {
            System.out.println("[FogWelcome] Could not save player data: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static boolean hasPlayerReceivedItemsInWorld(UUID playerId, String worldName) {
        return worldPlayerData.containsKey(worldName) && worldPlayerData.get(worldName).containsKey(playerId);
    }

    private static void markPlayerAsReceived(UUID playerId, String worldName) {
        worldPlayerData.computeIfAbsent(worldName, k -> new HashMap()).put(playerId, true);
    }
}

