/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="dont_look_into_the_fog", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SzadiSpawner {
    private static final Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();
    private static final int FOUR_MINUTES = 4800;
    private static final float SPAWN_CHANCE = 1.0f;
    private static final int ROTATION_TIME = 20;
    private static final int DESPAWN_TIME = 100;
    private static final int EFFECT_DURATION = 140;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.getServer() == null) {
            return;
        }
        for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
            PlayerData data = playerDataMap.computeIfAbsent(player.m_20148_(), k -> new PlayerData());
            SzadiSpawner.processPlayer(player, data);
        }
    }

    private static void processPlayer(ServerPlayer player, PlayerData data) {
        Level level = player.m_9236_();
        switch (data.actionStage) {
            case 1: {
                SzadiSpawner.playSound(player, level);
                SzadiSpawner.applySlownessEffect(player);
                data.startYaw = player.m_146908_();
                data.startPitch = player.m_146909_();
                data.targetYaw = SzadiSpawner.normalizeAngle(data.startYaw + 180.0f);
                data.targetPitch = data.startPitch;
                data.yawPerTick = SzadiSpawner.shortestRotation(data.startYaw, data.targetYaw) / 20.0f;
                data.pitchPerTick = (data.targetPitch - data.startPitch) / 20.0f;
                data.waitTicks = 0;
                data.actionStage = 2;
                break;
            }
            case 2: {
                if (data.waitTicks < 20) {
                    float currentYaw = data.startYaw + data.yawPerTick * (float)data.waitTicks;
                    float currentPitch = data.startPitch + data.pitchPerTick * (float)data.waitTicks;
                    player.m_146922_(SzadiSpawner.normalizeAngle(currentYaw));
                    player.m_146926_(SzadiSpawner.normalizeAngle(currentPitch));
                    player.f_8906_.m_9774_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SzadiSpawner.normalizeAngle(currentYaw), SzadiSpawner.normalizeAngle(currentPitch));
                    ++data.waitTicks;
                    break;
                }
                player.m_146922_(data.targetYaw);
                player.m_146926_(data.targetPitch);
                player.f_8906_.m_9774_(player.m_20185_(), player.m_20186_(), player.m_20189_(), data.targetYaw, data.targetPitch);
                data.waitTicks = 0;
                data.actionStage = 3;
                break;
            }
            case 3: {
                SzadiSpawner.spawnEntity(player, level, data);
                data.waitTicks = 0;
                data.actionStage = 4;
                break;
            }
            case 4: {
                ++data.waitTicks;
                if (data.waitTicks < 100) break;
                SzadiSpawner.despawnEntity(data);
                data.reset();
            }
        }
        if (data.actionStage == 0) {
            ++data.tickCounter;
            if (data.tickCounter >= 4800) {
                data.tickCounter = 0;
                if (Math.random() < 1.0) {
                    float playerYaw = player.m_146908_();
                    double yawRad = Math.toRadians(playerYaw);
                    double lookX = -Math.sin(yawRad);
                    double lookZ = Math.cos(yawRad);
                    data.spawnX = player.m_20185_() - lookX * 2.0;
                    data.spawnZ = player.m_20189_() - lookZ * 2.0;
                    data.spawnY = player.m_20186_();
                    data.actionStage = 1;
                }
            }
        }
    }

    private static void spawnEntity(ServerPlayer player, Level level, PlayerData data) {
        Entity entity;
        EntityType szadiType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("dont_look_into_the_fog", "szadi"));
        if (szadiType != null && (entity = szadiType.m_20615_(level)) != null) {
            entity.m_6034_(data.spawnX, data.spawnY, data.spawnZ);
            entity.m_20225_(true);
            entity.m_20331_(true);
            double dx = player.m_20185_() - data.spawnX;
            double dz = player.m_20189_() - data.spawnZ;
            float yawToPlayer = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
            entity.m_146922_(yawToPlayer);
            level.m_7967_(entity);
            data.spawnedEntity = entity;
        }
    }

    private static void despawnEntity(PlayerData data) {
        if (data.spawnedEntity != null) {
            data.spawnedEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            data.spawnedEntity = null;
        }
    }

    private static void applySlownessEffect(ServerPlayer player) {
        MobEffectInstance slowness = new MobEffectInstance(MobEffects.f_19597_, 140, 255, false, false, true);
        player.m_7292_(slowness);
    }

    private static void playSound(ServerPlayer player, Level level) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("dont_look_into_the_fog", "neckhurts"));
        if (sound != null) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private static float normalizeAngle(float angle) {
        if ((angle %= 360.0f) >= 180.0f) {
            angle -= 360.0f;
        }
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private static float shortestRotation(float start, float target) {
        float diff = target - start;
        if (diff > 180.0f) {
            diff -= 360.0f;
        }
        if (diff < -180.0f) {
            diff += 360.0f;
        }
        return diff;
    }

    private static class PlayerData {
        int tickCounter = 0;
        int actionStage = 0;
        int waitTicks = 0;
        Entity spawnedEntity = null;
        double spawnX;
        double spawnY;
        double spawnZ;
        float startYaw;
        float startPitch;
        float targetYaw;
        float targetPitch;
        float yawPerTick;
        float pitchPerTick;

        private PlayerData() {
        }

        void reset() {
            this.tickCounter = 0;
            this.actionStage = 0;
            this.waitTicks = 0;
            this.spawnedEntity = null;
        }
    }
}

