/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class TeleportSystem {
    private static final Random RANDOM = new Random();
    private static final int SELECTION_INTERVAL = 39080;
    private static final int RETURN_DELAY = 600;
    private static final Map<UUID, PlayerData> activePlayers = new HashMap<UUID, PlayerData>();
    private static final List<UUID> candidates = new ArrayList<UUID>();
    private static int selectionTimer = 0;
    private static int teleportCycleTimer = 0;
    private static boolean isSelectingPhase = true;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (isSelectingPhase) {
            TeleportSystem.handleSelectionPhase();
        } else {
            TeleportSystem.handleTeleportPhase();
        }
        TeleportSystem.updateActivePlayers();
    }

    private static void handleSelectionPhase() {
        if (++selectionTimer >= 39080) {
            selectionTimer = 0;
            TeleportSystem.selectRandomPlayer();
        }
    }

    private static void handleTeleportPhase() {
        if (++teleportCycleTimer >= 39080) {
            teleportCycleTimer = 0;
            isSelectingPhase = true;
            candidates.clear();
            System.out.println("TeleportSystem: Starting new selection cycle");
        }
    }

    private static void selectRandomPlayer() {
        List<ServerPlayer> onlinePlayers = TeleportSystem.getOnlinePlayers();
        if (onlinePlayers.isEmpty()) {
            System.out.println("TeleportSystem: No players online");
            return;
        }
        ArrayList<ServerPlayer> availablePlayers = new ArrayList<ServerPlayer>();
        for (ServerPlayer player : onlinePlayers) {
            if (activePlayers.containsKey(player.m_20148_()) || candidates.contains(player.m_20148_())) continue;
            availablePlayers.add(player);
        }
        if (availablePlayers.isEmpty()) {
            System.out.println("TeleportSystem: All players are already in teleport cycle");
            return;
        }
        ServerPlayer selectedPlayer = (ServerPlayer)availablePlayers.get(RANDOM.nextInt(availablePlayers.size()));
        candidates.add(selectedPlayer.m_20148_());
        System.out.println("TeleportSystem: Selected player for teleport: " + selectedPlayer.m_7755_().getString());
        TeleportSystem.teleportToRandomLocation(selectedPlayer);
        if (candidates.size() >= availablePlayers.size()) {
            isSelectingPhase = false;
            System.out.println("TeleportSystem: Switching to teleport phase");
        }
    }

    private static void teleportToRandomLocation(ServerPlayer player) {
        PlayerData data = new PlayerData();
        data.originalPos = player.m_20183_();
        data.originalLevel = (ServerLevel)player.m_9236_();
        data.shouldReturn = false;
        int x = RANDOM.nextInt(10000) - 5000;
        int z = RANDOM.nextInt(10000) - 5000;
        int y = TeleportSystem.findSafeY((ServerLevel)player.m_9236_(), x, z);
        if (y != -1) {
            data.randomDestination = new BlockPos(x, y, z);
            activePlayers.put(player.m_20148_(), data);
            TeleportSystem.giveBlindness(player, 40);
            TeleportSystem.performTeleport(player, data.randomDestination, "Where am I?");
            System.out.println("TeleportSystem: Teleported " + player.m_7755_().getString() + " to random location: " + String.valueOf(data.randomDestination));
        } else {
            System.out.println("TeleportSystem: Could not find safe location for " + player.m_7755_().getString());
        }
    }

    private static void updateActivePlayers() {
        Iterator<Map.Entry<UUID, PlayerData>> iterator = activePlayers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, PlayerData> entry = iterator.next();
            UUID playerId = entry.getKey();
            PlayerData data = entry.getValue();
            if (data.shouldReturn) {
                ServerPlayer player = TeleportSystem.getPlayerByUUID(playerId);
                if (player != null) {
                    TeleportSystem.returnPlayer(player, data);
                }
                iterator.remove();
                continue;
            }
            ++data.timer;
            if (data.timer < 600) continue;
            data.shouldReturn = true;
        }
    }

    private static void returnPlayer(ServerPlayer player, PlayerData data) {
        System.out.println("TeleportSystem: Returning player: " + player.m_7755_().getString());
        TeleportSystem.giveBlindness(player, 40);
        TeleportSystem.performTeleport(player, data.originalPos, "");
        System.out.println("TeleportSystem: Player " + player.m_7755_().getString() + " returned to original position: " + String.valueOf(data.originalPos));
    }

    private static void giveBlindness(ServerPlayer player, int duration) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, duration, 0, false, false));
    }

    private static void performTeleport(ServerPlayer player, BlockPos pos, String message) {
        if (player.m_20194_() != null) {
            ServerLevel targetLevel = player.m_284548_();
            player.m_8999_(targetLevel, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
            if (!message.isEmpty()) {
                player.m_5661_((Component)Component.m_237113_((String)("\u00a76" + message)), true);
            }
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)SoundEvents.f_11689_.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    private static int findSafeY(ServerLevel level, int x, int z) {
        for (int y = level.m_151558_(); y >= level.m_141937_(); --y) {
            BlockPos pos = new BlockPos(x, y, z);
            BlockPos posAbove = new BlockPos(x, y + 1, z);
            if (level.m_46859_(pos) || !level.m_46859_(posAbove) || !level.m_46859_(pos.m_6630_(2))) continue;
            return y + 1;
        }
        return -1;
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            UUID playerId = player2.m_20148_();
            activePlayers.remove(playerId);
            candidates.remove(playerId);
        }
    }

    private static List<ServerPlayer> getOnlinePlayers() {
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>();
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                players.addAll(server.m_6846_().m_11314_());
            }
        }
        catch (Exception e) {
            System.err.println("Error getting online players: " + e.getMessage());
        }
        return players;
    }

    private static ServerPlayer getPlayerByUUID(UUID uuid) {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                return server.m_6846_().m_11259_(uuid);
            }
        }
        catch (Exception e) {
            System.err.println("Error getting player by UUID: " + e.getMessage());
        }
        return null;
    }

    private static class PlayerData {
        BlockPos originalPos;
        ServerLevel originalLevel;
        int timer = 0;
        boolean shouldReturn = false;
        BlockPos randomDestination;

        private PlayerData() {
        }
    }
}

