/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog.events;

import net.mcreator.dontlookintothefog.events.EvilFogEvent;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class FogRenderer {
    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        float density = EvilFogEvent.getFogDensity(minecraft.f_91074_.m_20148_());
        if (density > 0.0f) {
            float nearPlane = 2.0f;
            float farPlane = 50.0f - density * 40.0f;
            event.setNearPlaneDistance(nearPlane);
            event.setFarPlaneDistance(Math.max(nearPlane + 5.0f, farPlane));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFogColor(ViewportEvent.ComputeFogColor event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        float density = EvilFogEvent.getFogDensity(minecraft.f_91074_.m_20148_());
        if (density > 0.0f) {
            float fogIntensity = density * 0.7f;
            event.setRed(0.5f * (1.0f - fogIntensity) + 0.3f * fogIntensity);
            event.setGreen(0.5f * (1.0f - fogIntensity) + 0.3f * fogIntensity);
            event.setBlue(0.6f * (1.0f - fogIntensity) + 0.4f * fogIntensity);
        }
    }
}

