/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.custom_blocks;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FigurineBlock
extends HorizontalDirectionalBlock {
    protected final FigurineVariant variant;

    protected FigurineBlock(FigurineVariant variant) {
        super(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.DESTROY).m_60918_(SoundType.f_56742_));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
        this.variant = variant;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public abstract ResourceLocation getTexture();

    public static enum FigurineVariant implements StringRepresentable
    {
        DESTROYED("destroyed"),
        RESTORED("restored"),
        PRISTINE("pristine");

        private final String name;
        private final ResourceLocation anuTexture;
        private final ResourceLocation endermanTexture;
        private final ResourceLocation piglinTexture;
        private final ResourceLocation skeletonTexture;
        private final ResourceLocation steveTexture;
        private final ResourceLocation zombieTexture;

        private FigurineVariant(String name) {
            this.name = name;
            this.anuTexture = FossilMod.location("textures/block/figurines/figurine_anu_" + name + ".png");
            this.endermanTexture = FossilMod.location("textures/block/figurines/figurine_enderman_" + name + ".png");
            this.piglinTexture = FossilMod.location("textures/block/figurines/figurine_piglin_" + name + ".png");
            this.skeletonTexture = FossilMod.location("textures/block/figurines/figurine_skeleton_" + name + ".png");
            this.steveTexture = FossilMod.location("textures/block/figurines/figurine_steve_" + name + ".png");
            this.zombieTexture = FossilMod.location("textures/block/figurines/figurine_zombie_" + name + ".png");
        }

        public ResourceLocation getAnuTexture() {
            return this.anuTexture;
        }

        public ResourceLocation getEndermanTexture() {
            return this.endermanTexture;
        }

        public ResourceLocation getPiglinTexture() {
            return this.piglinTexture;
        }

        public ResourceLocation getSkeletonTexture() {
            return this.skeletonTexture;
        }

        public ResourceLocation getSteveTexture() {
            return this.steveTexture;
        }

        public ResourceLocation getZombieTexture() {
            return this.zombieTexture;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

