/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.custom_blocks;

import com.github.teamfossilsarcheology.fossil.block.PrehistoricPlantInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class ShortBerryBushBlock
extends BushBlock
implements BonemealableBlock {
    private final VoxelShape shape;
    private final PrehistoricPlantInfo info;

    protected ShortBerryBushBlock(VoxelShape shape, PrehistoricPlantInfo info) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_278166_(PushReaction.DESTROY).m_60910_().m_60977_().m_60918_(SoundType.f_56757_));
        this.shape = shape;
        this.info = info;
    }

    public abstract IntegerProperty ageProperty();

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)this.ageProperty()) < this.info.maxAge();
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = (Integer)state.m_61143_((Property)this.ageProperty());
        if (i < this.info.maxAge() && random.m_188503_(5) == 0 && level.m_45524_(pos.m_7494_(), 0) >= 9) {
            this.updateAge((Level)level, pos, state, i + 1);
        }
    }

    private void updateAge(Level level, BlockPos pos, BlockState state, int nextAge) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.ageProperty(), (Comparable)Integer.valueOf(nextAge)), 2);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean isMaxAge;
        int i = (Integer)state.m_61143_((Property)this.ageProperty());
        boolean bl = isMaxAge = i == this.info.maxAge();
        if (!isMaxAge && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (i >= this.info.berryAge()) {
            int dropAmount = 1 + level.f_46441_.m_188503_(2) + i - this.info.berryAge();
            SweetBerryBushBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.info.berryItem().get(), dropAmount));
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            this.updateAge(level, pos, state, this.info.berryAge() - 1);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.ageProperty()});
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)this.ageProperty()) < this.info.maxAge();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.updateAge((Level)level, pos, state, Math.min(this.info.maxAge(), (Integer)state.m_61143_((Property)this.ageProperty()) + 1));
    }
}

